/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.util.HtmlUtils;

public class EscapedErrors
implements Errors {
    private final Errors source;

    public EscapedErrors(Errors errors) {
        if (errors == null) {
            throw new IllegalArgumentException("Cannot wrap a null instance");
        }
        this.source = errors;
    }

    public Errors getSource() {
        return this.source;
    }

    public String getObjectName() {
        return this.source.getObjectName();
    }

    public void setNestedPath(String string) {
        this.source.setNestedPath(string);
    }

    public String getNestedPath() {
        return this.source.getNestedPath();
    }

    public void pushNestedPath(String string) {
        this.source.pushNestedPath(string);
    }

    public void popNestedPath() throws IllegalStateException {
        this.source.popNestedPath();
    }

    public void reject(String string) {
        this.source.reject(string);
    }

    public void reject(String string, String string2) {
        this.source.reject(string, string2);
    }

    public void reject(String string, Object[] objectArray, String string2) {
        this.source.reject(string, objectArray, string2);
    }

    public void rejectValue(String string, String string2) {
        this.source.rejectValue(string, string2);
    }

    public void rejectValue(String string, String string2, String string3) {
        this.source.rejectValue(string, string2, string3);
    }

    public void rejectValue(String string, String string2, Object[] objectArray, String string3) {
        this.source.rejectValue(string, string2, objectArray, string3);
    }

    public void addAllErrors(Errors errors) {
        this.source.addAllErrors(errors);
    }

    public boolean hasErrors() {
        return this.source.hasErrors();
    }

    public int getErrorCount() {
        return this.source.getErrorCount();
    }

    public List getAllErrors() {
        return this.escapeObjectErrors(this.source.getAllErrors());
    }

    public boolean hasGlobalErrors() {
        return this.source.hasGlobalErrors();
    }

    public int getGlobalErrorCount() {
        return this.source.getGlobalErrorCount();
    }

    public List getGlobalErrors() {
        return this.escapeObjectErrors(this.source.getGlobalErrors());
    }

    public ObjectError getGlobalError() {
        return this.escapeObjectError(this.source.getGlobalError());
    }

    public boolean hasFieldErrors() {
        return this.source.hasFieldErrors();
    }

    public int getFieldErrorCount() {
        return this.source.getFieldErrorCount();
    }

    public List getFieldErrors() {
        return this.source.getFieldErrors();
    }

    public FieldError getFieldError() {
        return this.source.getFieldError();
    }

    public boolean hasFieldErrors(String string) {
        return this.source.hasFieldErrors(string);
    }

    public int getFieldErrorCount(String string) {
        return this.source.getFieldErrorCount(string);
    }

    public List getFieldErrors(String string) {
        return this.escapeObjectErrors(this.source.getFieldErrors(string));
    }

    public FieldError getFieldError(String string) {
        return (FieldError)this.escapeObjectError((ObjectError)this.source.getFieldError(string));
    }

    public Object getFieldValue(String string) {
        Object object = this.source.getFieldValue(string);
        return object instanceof String ? HtmlUtils.htmlEscape((String)object) : object;
    }

    public Class getFieldType(String string) {
        return this.source.getFieldType(string);
    }

    private ObjectError escapeObjectError(ObjectError objectError) {
        if (objectError == null) {
            return null;
        }
        if (objectError instanceof FieldError) {
            FieldError fieldError = (FieldError)objectError;
            Object object = fieldError.getRejectedValue();
            if (object instanceof String) {
                object = HtmlUtils.htmlEscape((String)object);
            }
            return new FieldError(fieldError.getObjectName(), fieldError.getField(), object, fieldError.isBindingFailure(), fieldError.getCodes(), fieldError.getArguments(), HtmlUtils.htmlEscape(fieldError.getDefaultMessage()));
        }
        return new ObjectError(objectError.getObjectName(), objectError.getCodes(), objectError.getArguments(), HtmlUtils.htmlEscape(objectError.getDefaultMessage()));
    }

    private List escapeObjectErrors(List list) {
        ArrayList<ObjectError> arrayList = new ArrayList<ObjectError>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectError objectError = (ObjectError)iterator.next();
            arrayList.add(this.escapeObjectError(objectError));
        }
        return arrayList;
    }
}

