/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.BindInitializer;
import org.springframework.web.bind.ServletRequestDataBinder;

public abstract class BindUtils {
    public static BindException bind(ServletRequest servletRequest, Object object, String string) {
        ServletRequestDataBinder servletRequestDataBinder = new ServletRequestDataBinder(object, string);
        servletRequestDataBinder.bind(servletRequest);
        return servletRequestDataBinder.getErrors();
    }

    public static BindException bind(ServletRequest servletRequest, Object object, String string, BindInitializer bindInitializer) throws ServletException {
        ServletRequestDataBinder servletRequestDataBinder = new ServletRequestDataBinder(object, string);
        if (bindInitializer != null) {
            bindInitializer.initBinder(servletRequest, servletRequestDataBinder);
        }
        servletRequestDataBinder.bind(servletRequest);
        return servletRequestDataBinder.getErrors();
    }

    public static BindException bindAndValidate(ServletRequest servletRequest, Object object, String string, Validator validator) {
        BindException bindException = BindUtils.bind(servletRequest, object, string);
        if (validator != null) {
            ValidationUtils.invokeValidator((Validator)validator, (Object)object, (Errors)bindException);
        }
        return bindException;
    }

    public static BindException bindAndValidate(ServletRequest servletRequest, Object object, String string, Validator validator, BindInitializer bindInitializer) throws ServletException {
        BindException bindException = BindUtils.bind(servletRequest, object, string, bindInitializer);
        if (validator != null) {
            ValidationUtils.invokeValidator((Validator)validator, (Object)object, (Errors)bindException);
        }
        return bindException;
    }
}

