/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jocl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.jocl.ConstructorUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JOCLContentHandler
extends DefaultHandler {
    public static final String JOCL_NAMESPACE_URI = "http://apache.org/xml/xmlns/jakarta/commons/jocl";
    public static final String JOCL_PREFIX = "jocl:";
    protected ArrayList _typeList = new ArrayList();
    protected ArrayList _valueList = new ArrayList();
    protected ConstructorDetails _cur = null;
    protected boolean _acceptEmptyNamespaceForElements = true;
    protected boolean _acceptJoclPrefixForElements = true;
    protected boolean _acceptEmptyNamespaceForAttributes = true;
    protected boolean _acceptJoclPrefixForAttributes = true;
    protected Locator _locator = null;
    protected static final String ELT_OBJECT = "object";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_ISNULL = "null";
    protected static final String ELT_BOOLEAN = "boolean";
    protected static final String ELT_BYTE = "byte";
    protected static final String ELT_CHAR = "char";
    protected static final String ELT_DOUBLE = "double";
    protected static final String ELT_FLOAT = "float";
    protected static final String ELT_INT = "int";
    protected static final String ELT_LONG = "long";
    protected static final String ELT_SHORT = "short";
    protected static final String ELT_STRING = "string";
    protected static final String ATT_VALUE = "value";

    public static void main(String[] stringArray) throws Exception {
        JOCLContentHandler jOCLContentHandler = JOCLContentHandler.parse(System.in, null);
        for (int i = 0; i < jOCLContentHandler.size(); ++i) {
            System.out.println("<" + jOCLContentHandler.getType(i) + ">\t" + jOCLContentHandler.getValue(i));
        }
    }

    public static JOCLContentHandler parse(File file) throws SAXException, FileNotFoundException, IOException {
        return JOCLContentHandler.parse(new FileInputStream(file), null);
    }

    public static JOCLContentHandler parse(Reader reader) throws SAXException, IOException {
        return JOCLContentHandler.parse(new InputSource(reader), null);
    }

    public static JOCLContentHandler parse(InputStream inputStream) throws SAXException, IOException {
        return JOCLContentHandler.parse(new InputSource(inputStream), null);
    }

    public static JOCLContentHandler parse(InputSource inputSource) throws SAXException, IOException {
        return JOCLContentHandler.parse(inputSource, null);
    }

    public static JOCLContentHandler parse(File file, XMLReader xMLReader) throws SAXException, FileNotFoundException, IOException {
        return JOCLContentHandler.parse(new FileInputStream(file), xMLReader);
    }

    public static JOCLContentHandler parse(Reader reader, XMLReader xMLReader) throws SAXException, IOException {
        return JOCLContentHandler.parse(new InputSource(reader), xMLReader);
    }

    public static JOCLContentHandler parse(InputStream inputStream, XMLReader xMLReader) throws SAXException, IOException {
        return JOCLContentHandler.parse(new InputSource(inputStream), xMLReader);
    }

    public static JOCLContentHandler parse(InputSource inputSource, XMLReader xMLReader) throws SAXException, IOException {
        JOCLContentHandler jOCLContentHandler = new JOCLContentHandler();
        if (null == xMLReader) {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        xMLReader.setContentHandler(jOCLContentHandler);
        xMLReader.parse(inputSource);
        return jOCLContentHandler;
    }

    public JOCLContentHandler() {
        this(true, true, true, true);
    }

    public JOCLContentHandler(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._acceptEmptyNamespaceForElements = bl;
        this._acceptJoclPrefixForElements = bl2;
        this._acceptEmptyNamespaceForAttributes = bl3;
        this._acceptJoclPrefixForAttributes = bl4;
    }

    public int size() {
        return this._typeList.size();
    }

    public void clear() {
        this._typeList = new ArrayList();
        this._valueList = new ArrayList();
    }

    public void clear(int n) {
        this._typeList.remove(n);
        this._valueList.remove(n);
    }

    public Class getType(int n) {
        return (Class)this._typeList.get(n);
    }

    public Object getValue(int n) {
        return this._valueList.get(n);
    }

    public Object[] getValueArray() {
        return this._valueList.toArray();
    }

    public Object[] getTypeArray() {
        return this._typeList.toArray();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (this.isJoclNamespace(string, string2, string3)) {
                if (ELT_OBJECT.equals(string2)) {
                    String string4 = this.getAttributeValue(ATT_CLASS, attributes);
                    String string5 = this.getAttributeValue(ATT_ISNULL, attributes, "false");
                    boolean bl = "true".equalsIgnoreCase(string5) || "yes".equalsIgnoreCase(string5);
                    this._cur = new ConstructorDetails(string4, this._cur, bl);
                } else if (ELT_BOOLEAN.equals(string2)) {
                    String string6 = this.getAttributeValue(ATT_VALUE, attributes, "false");
                    boolean bl = "true".equalsIgnoreCase(string6) || "yes".equalsIgnoreCase(string6);
                    this.addObject(Boolean.TYPE, new Boolean(bl));
                } else if (ELT_BYTE.equals(string2)) {
                    byte by = Byte.parseByte(this.getAttributeValue(ATT_VALUE, attributes, "0"));
                    this.addObject(Byte.TYPE, new Byte(by));
                } else if (ELT_CHAR.equals(string2)) {
                    char c = '\u0000';
                    String string7 = this.getAttributeValue(ATT_VALUE, attributes);
                    if (null == string7) {
                        c = '\u0000';
                    } else {
                        if (string7.length() > 1) {
                            throw new SAXException("if present, char value must be exactly one character long");
                        }
                        if (string7.length() == 1) {
                            c = string7.charAt(0);
                        } else if (string7.length() == 0) {
                            throw new SAXException("if present, char value must be exactly one character long");
                        }
                    }
                    this.addObject(Character.TYPE, new Character(c));
                } else if (ELT_DOUBLE.equals(string2)) {
                    double d = Double.parseDouble(this.getAttributeValue(ATT_VALUE, attributes, "0"));
                    this.addObject(Double.TYPE, new Double(d));
                } else if (ELT_FLOAT.equals(string2)) {
                    float f = Float.parseFloat(this.getAttributeValue(ATT_VALUE, attributes, "0"));
                    this.addObject(Float.TYPE, new Float(f));
                } else if (ELT_INT.equals(string2)) {
                    int n = Integer.parseInt(this.getAttributeValue(ATT_VALUE, attributes, "0"));
                    this.addObject(Integer.TYPE, new Integer(n));
                } else if (ELT_LONG.equals(string2)) {
                    long l = Long.parseLong(this.getAttributeValue(ATT_VALUE, attributes, "0"));
                    this.addObject(Long.TYPE, new Long(l));
                } else if (ELT_SHORT.equals(string2)) {
                    short s = Short.parseShort(this.getAttributeValue(ATT_VALUE, attributes, "0"));
                    this.addObject(Short.TYPE, new Short(s));
                } else if (ELT_STRING.equals(string2)) {
                    String string8 = this.getAttributeValue(ATT_VALUE, attributes);
                    this.addObject("".getClass(), string8);
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.isJoclNamespace(string, string2, string3) && ELT_OBJECT.equals(string2)) {
                ConstructorDetails constructorDetails = this._cur;
                this._cur = this._cur.getParent();
                if (null == this._cur) {
                    this._typeList.add(constructorDetails.getType());
                    this._valueList.add(constructorDetails.createObject());
                } else {
                    this._cur.addArgument(constructorDetails.getType(), constructorDetails.createObject());
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    protected boolean isJoclNamespace(String string, String string2, String string3) {
        if (JOCL_NAMESPACE_URI.equals(string)) {
            return true;
        }
        if (this._acceptEmptyNamespaceForElements && (null == string || "".equals(string))) {
            return true;
        }
        return this._acceptJoclPrefixForElements && (null == string || "".equals(string)) && string3.startsWith(JOCL_PREFIX);
    }

    protected String getAttributeValue(String string, Attributes attributes) {
        return this.getAttributeValue(string, attributes, null);
    }

    protected String getAttributeValue(String string, Attributes attributes, String string2) {
        String string3 = attributes.getValue(JOCL_NAMESPACE_URI, string);
        if (null == string3 && this._acceptEmptyNamespaceForAttributes) {
            string3 = attributes.getValue("", string);
        }
        if (null == string3 && this._acceptJoclPrefixForAttributes) {
            string3 = attributes.getValue("", JOCL_PREFIX + string);
        }
        return null == string3 ? string2 : string3;
    }

    protected void addObject(Class clazz, Object object) {
        if (null == this._cur) {
            this._typeList.add(clazz);
            this._valueList.add(object);
        } else {
            this._cur.addArgument(clazz, object);
        }
    }

    class ConstructorDetails {
        private ConstructorDetails _parent = null;
        private Class _type = null;
        private ArrayList _argTypes = null;
        private ArrayList _argValues = null;
        private boolean _isnull = false;

        public ConstructorDetails(String string, ConstructorDetails constructorDetails) throws ClassNotFoundException {
            this(Class.forName(string), constructorDetails, false);
        }

        public ConstructorDetails(String string, ConstructorDetails constructorDetails, boolean bl) throws ClassNotFoundException {
            this(Class.forName(string), constructorDetails, bl);
        }

        public ConstructorDetails(Class clazz, ConstructorDetails constructorDetails, boolean bl) {
            this._parent = constructorDetails;
            this._type = clazz;
            this._argTypes = new ArrayList();
            this._argValues = new ArrayList();
            this._isnull = bl;
        }

        public void addArgument(Object object) {
            this.addArgument(object.getClass(), object);
        }

        public void addArgument(Class clazz, Object object) {
            if (this._isnull) {
                throw new NullPointerException("can't add arguments to null instances");
            }
            this._argTypes.add(clazz);
            this._argValues.add(object);
        }

        public Class getType() {
            return this._type;
        }

        public ConstructorDetails getParent() {
            return this._parent;
        }

        public Object createObject() throws InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
            if (this._isnull) {
                return null;
            }
            Class clazz = this.getType();
            Class[] classArray = this._argTypes.toArray(new Class[0]);
            Object[] objectArray = this._argValues.toArray();
            return ConstructorUtil.invokeConstructor(clazz, classArray, objectArray);
        }
    }
}

