/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jocl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ConstructorUtil {
    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        if (null == clazz || null == classArray) {
            throw new NullPointerException();
        }
        Constructor<Object> constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            constructor = null;
        }
        if (null == constructor) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray2 = constructorArray[i].getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < classArray2.length; ++j) {
                    if (classArray2[j].isAssignableFrom(classArray[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                constructor = constructorArray[i];
                break;
            }
        }
        return constructor;
    }

    public static Object invokeConstructor(Class clazz, Class[] classArray, Object[] objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return ConstructorUtil.getConstructor(clazz, classArray).newInstance(objectArray);
    }
}

