/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.commons.dbcp.datasources.KeyedCPDSConnectionFactory;
import org.apache.commons.dbcp.datasources.LRUMap;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.SharedPoolDataSourceFactory;
import org.apache.commons.dbcp.datasources.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private final Map userKeys = new LRUMap(10);
    private int maxActive = 8;
    private int maxIdle = 8;
    private int maxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    private KeyedObjectPool pool = null;
    static /* synthetic */ Class class$org$apache$commons$dbcp$datasources$SharedPoolDataSourceFactory;

    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n) {
        this.assertInitializationAllowed();
        this.maxActive = n;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.maxIdle = n;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int n) {
        this.assertInitializationAllowed();
        this.maxWait = n;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    protected synchronized PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        if (this.pool == null) {
            try {
                this.registerPool(string, string2);
            }
            catch (NamingException namingException) {
                throw new SQLNestedException("RegisterPool failed", namingException);
            }
        }
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pool.borrowObject((Object)this.getUserPassKey(string, string2));
        }
        catch (Exception exception) {
            throw new SQLNestedException("Could not retrieve connection info from pool", exception);
        }
        return pooledConnectionAndInfo;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), (class$org$apache$commons$dbcp$datasources$SharedPoolDataSourceFactory == null ? (class$org$apache$commons$dbcp$datasources$SharedPoolDataSourceFactory = SharedPoolDataSource.class$("org.apache.commons.dbcp.datasources.SharedPoolDataSourceFactory")) : class$org$apache$commons$dbcp$datasources$SharedPoolDataSourceFactory).getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.instanceKey));
        return reference;
    }

    private UserPassKey getUserPassKey(String string, String string2) {
        UserPassKey userPassKey = (UserPassKey)this.userKeys.get(string);
        if (userPassKey == null) {
            userPassKey = new UserPassKey(string, string2);
            this.userKeys.put(string, userPassKey);
        }
        return userPassKey;
    }

    private void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        GenericKeyedObjectPool genericKeyedObjectPool = new GenericKeyedObjectPool(null);
        genericKeyedObjectPool.setMaxActive(this.getMaxActive());
        genericKeyedObjectPool.setMaxIdle(this.getMaxIdle());
        genericKeyedObjectPool.setMaxWait((long)this.getMaxWait());
        genericKeyedObjectPool.setWhenExhaustedAction(this.whenExhaustedAction(this.maxActive, this.maxWait));
        genericKeyedObjectPool.setTestOnBorrow(this.getTestOnBorrow());
        genericKeyedObjectPool.setTestOnReturn(this.getTestOnReturn());
        genericKeyedObjectPool.setTimeBetweenEvictionRunsMillis((long)this.getTimeBetweenEvictionRunsMillis());
        genericKeyedObjectPool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        genericKeyedObjectPool.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis());
        genericKeyedObjectPool.setTestWhileIdle(this.getTestWhileIdle());
        this.pool = genericKeyedObjectPool;
        new KeyedCPDSConnectionFactory(connectionPoolDataSource, this.pool, this.getValidationQuery(), this.isRollbackAfterValidation());
    }

    protected void setupDefaults(Connection connection, String string) throws SQLException {
        connection.setAutoCommit(this.isDefaultAutoCommit());
        int n = this.getDefaultTransactionIsolation();
        if (n != -1) {
            connection.setTransactionIsolation(n);
        }
        connection.setReadOnly(this.isDefaultReadOnly());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            SharedPoolDataSource sharedPoolDataSource = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = sharedPoolDataSource.pool;
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + namingException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

