/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.commons.dbcp.datasources.PerUserPoolDataSourceFactory;
import org.apache.commons.dbcp.datasources.PoolKey;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final Map poolKeys = new HashMap();
    private int defaultMaxActive = 8;
    private int defaultMaxIdle = 8;
    private int defaultMaxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    Map perUserDefaultAutoCommit = null;
    Map perUserDefaultTransactionIsolation = null;
    Map perUserMaxActive = null;
    Map perUserMaxIdle = null;
    Map perUserMaxWait = null;
    Map perUserDefaultReadOnly = null;
    private transient Map pools = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$dbcp$datasources$PerUserPoolDataSourceFactory;

    private static void close(Map map) {
    }

    public void close() {
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((ObjectPool)iterator.next()).close();
            }
            catch (Exception exception) {}
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getDefaultMaxActive() {
        return this.defaultMaxActive;
    }

    public void setDefaultMaxActive(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxActive = n;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = n;
    }

    public int getDefaultMaxWait() {
        return this.defaultMaxWait;
    }

    public void setDefaultMaxWait(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxWait = n;
    }

    public Boolean getPerUserDefaultAutoCommit(String string) {
        Boolean bl = null;
        if (this.perUserDefaultAutoCommit != null) {
            bl = (Boolean)this.perUserDefaultAutoCommit.get(string);
        }
        return bl;
    }

    public void setPerUserDefaultAutoCommit(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap();
        }
        this.perUserDefaultAutoCommit.put(string, bl);
    }

    public Integer getPerUserDefaultTransactionIsolation(String string) {
        Integer n = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            n = (Integer)this.perUserDefaultTransactionIsolation.get(string);
        }
        return n;
    }

    public void setPerUserDefaultTransactionIsolation(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap();
        }
        this.perUserDefaultTransactionIsolation.put(string, n);
    }

    public Integer getPerUserMaxActive(String string) {
        Integer n = null;
        if (this.perUserMaxActive != null) {
            n = (Integer)this.perUserMaxActive.get(string);
        }
        return n;
    }

    public void setPerUserMaxActive(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxActive == null) {
            this.perUserMaxActive = new HashMap();
        }
        this.perUserMaxActive.put(string, n);
    }

    public Integer getPerUserMaxIdle(String string) {
        Integer n = null;
        if (this.perUserMaxIdle != null) {
            n = (Integer)this.perUserMaxIdle.get(string);
        }
        return n;
    }

    public void setPerUserMaxIdle(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap();
        }
        this.perUserMaxIdle.put(string, n);
    }

    public Integer getPerUserMaxWait(String string) {
        Integer n = null;
        if (this.perUserMaxWait != null) {
            n = (Integer)this.perUserMaxWait.get(string);
        }
        return n;
    }

    public void setPerUserMaxWait(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWait == null) {
            this.perUserMaxWait = new HashMap();
        }
        this.perUserMaxWait.put(string, n);
    }

    public Boolean getPerUserDefaultReadOnly(String string) {
        Boolean bl = null;
        if (this.perUserDefaultReadOnly != null) {
            bl = (Boolean)this.perUserDefaultReadOnly.get(string);
        }
        return bl;
    }

    public void setPerUserDefaultReadOnly(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap();
        }
        this.perUserDefaultReadOnly.put(string, bl);
    }

    public int getNumActive() {
        return this.getNumActive(null, null);
    }

    public int getNumActive(String string, String string2) {
        ObjectPool objectPool = (ObjectPool)this.pools.get(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null, null);
    }

    public int getNumIdle(String string, String string2) {
        ObjectPool objectPool = (ObjectPool)this.pools.get(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumIdle();
    }

    protected synchronized PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        PoolKey poolKey = this.getPoolKey(string);
        Object v = this.pools.get(poolKey);
        if (v == null) {
            try {
                this.registerPool(string, string2);
                v = this.pools.get(poolKey);
            }
            catch (NamingException namingException) {
                throw new SQLNestedException("RegisterPool failed", namingException);
            }
        }
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = (PooledConnectionAndInfo)((ObjectPool)v).borrowObject();
        }
        catch (Exception exception) {
            throw new SQLNestedException("Could not retrieve connection info from pool", exception);
        }
        return pooledConnectionAndInfo;
    }

    protected void setupDefaults(Connection connection, String string) throws SQLException {
        Integer n;
        Boolean bl;
        Boolean bl2;
        boolean bl3 = this.isDefaultAutoCommit();
        if (string != null && (bl2 = this.getPerUserDefaultAutoCommit(string)) != null) {
            bl3 = bl2;
        }
        boolean bl4 = this.isDefaultReadOnly();
        if (string != null && (bl = this.getPerUserDefaultReadOnly(string)) != null) {
            bl4 = bl;
        }
        int n2 = this.getDefaultTransactionIsolation();
        if (string != null && (n = this.getPerUserDefaultTransactionIsolation(string)) != null) {
            n2 = n;
        }
        connection.setAutoCommit(bl3);
        if (n2 != -1) {
            connection.setTransactionIsolation(n2);
        }
        connection.setReadOnly(bl4);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), (class$org$apache$commons$dbcp$datasources$PerUserPoolDataSourceFactory == null ? (class$org$apache$commons$dbcp$datasources$PerUserPoolDataSourceFactory = PerUserPoolDataSource.class$("org.apache.commons.dbcp.datasources.PerUserPoolDataSourceFactory")) : class$org$apache$commons$dbcp$datasources$PerUserPoolDataSourceFactory).getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.instanceKey));
        return reference;
    }

    private PoolKey getPoolKey(String string) {
        PoolKey poolKey = null;
        String string2 = this.getDataSourceName();
        HashMap<String, PoolKey> hashMap = (HashMap<String, PoolKey>)poolKeys.get(string2);
        if (hashMap != null) {
            poolKey = (PoolKey)hashMap.get(string);
        }
        if (poolKey == null) {
            poolKey = new PoolKey(string2, string);
            if (hashMap == null) {
                hashMap = new HashMap<String, PoolKey>();
                poolKeys.put(string2, hashMap);
            }
            hashMap.put(string, poolKey);
        }
        return poolKey;
    }

    private synchronized void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        Integer n = this.getPerUserMaxActive(string);
        int n2 = n == null ? this.getDefaultMaxActive() : n.intValue();
        n = this.getPerUserMaxIdle(string);
        int n3 = n == null ? this.getDefaultMaxIdle() : n.intValue();
        n = this.getPerUserMaxWait(string);
        int n4 = n == null ? this.getDefaultMaxWait() : n.intValue();
        GenericObjectPool genericObjectPool = new GenericObjectPool(null);
        genericObjectPool.setMaxActive(n2);
        genericObjectPool.setMaxIdle(n3);
        genericObjectPool.setMaxWait((long)n4);
        genericObjectPool.setWhenExhaustedAction(this.whenExhaustedAction(n2, n4));
        genericObjectPool.setTestOnBorrow(this.getTestOnBorrow());
        genericObjectPool.setTestOnReturn(this.getTestOnReturn());
        genericObjectPool.setTimeBetweenEvictionRunsMillis((long)this.getTimeBetweenEvictionRunsMillis());
        genericObjectPool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        genericObjectPool.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis());
        genericObjectPool.setTestWhileIdle(this.getTestWhileIdle());
        new CPDSConnectionFactory(connectionPoolDataSource, (ObjectPool)genericObjectPool, this.getValidationQuery(), this.isRollbackAfterValidation(), string, string2);
        this.pools.put(this.getPoolKey(string), genericObjectPool);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            PerUserPoolDataSource perUserPoolDataSource = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pools = perUserPoolDataSource.pools;
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + namingException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

