/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected boolean _rollbackAfterValidation = false;
    protected KeyedObjectPool _pool = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, KeyedObjectPool keyedObjectPool, String string) {
        this._cpds = connectionPoolDataSource;
        this._pool = keyedObjectPool;
        this._pool.setFactory((KeyedPoolableObjectFactory)this);
        this._validationQuery = string;
    }

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, KeyedObjectPool keyedObjectPool, String string, boolean bl) {
        this(connectionPoolDataSource, keyedObjectPool, string);
        this._rollbackAfterValidation = bl;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource connectionPoolDataSource) {
        this._cpds = connectionPoolDataSource;
    }

    public synchronized void setValidationQuery(String string) {
        this._validationQuery = string;
    }

    public synchronized void setRollbackAfterValidation(boolean bl) {
        this._rollbackAfterValidation = bl;
    }

    public synchronized void setPool(KeyedObjectPool keyedObjectPool) throws SQLException {
        if (null != this._pool && keyedObjectPool != this._pool) {
            try {
                this._pool.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot set the pool on this factory", exception);
            }
        }
        this._pool = keyedObjectPool;
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object object) throws Exception {
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        UserPassKey userPassKey = (UserPassKey)object;
        PooledConnection pooledConnection = null;
        String string = userPassKey.getUsername();
        String string2 = userPassKey.getPassword();
        pooledConnection = string == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(string, string2);
        pooledConnection.addConnectionEventListener(this);
        pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, string, string2);
        this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        return pooledConnectionAndInfo;
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        if (object2 instanceof PooledConnectionAndInfo) {
            PooledConnection pooledConnection = ((PooledConnectionAndInfo)object2).getPooledConnection();
            this.pcMap.remove(pooledConnection);
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean validateObject(Object object, Object object2) {
        boolean bl;
        block31: {
            bl = false;
            if (object2 instanceof PooledConnectionAndInfo) {
                PooledConnection pooledConnection = ((PooledConnectionAndInfo)object2).getPooledConnection();
                String string = this._validationQuery;
                if (null != string) {
                    Throwable throwable2222;
                    ResultSet resultSet;
                    Statement statement;
                    Connection connection;
                    block28: {
                        block27: {
                            connection = null;
                            statement = null;
                            resultSet = null;
                            this.validatingMap.put(pooledConnection, null);
                            connection = pooledConnection.getConnection();
                            statement = connection.createStatement();
                            resultSet = statement.executeQuery(string);
                            bl = resultSet.next();
                            if (!this._rollbackAfterValidation) break block27;
                            connection.rollback();
                        }
                        Object var11_9 = null;
                        if (resultSet == null) break block28;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2222) {
                            // empty catch block
                        }
                    }
                    this.validatingMap.remove(pooledConnection);
                    {
                        break block31;
                        catch (Exception exception) {
                            Throwable throwable32222;
                            bl = false;
                            Object var11_10 = null;
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable32222) {
                                    // empty catch block
                                }
                            }
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable32222) {
                                    // empty catch block
                                }
                            }
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable32222) {
                                    // empty catch block
                                }
                            }
                            this.validatingMap.remove(pooledConnection);
                            break block31;
                        }
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable52222;
                        Object var11_11 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable52222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable52222) {
                                // empty catch block
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable52222) {
                                // empty catch block
                            }
                        }
                        this.validatingMap.remove(pooledConnection);
                        throw throwable4;
                    }
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void passivateObject(Object object, Object object2) {
    }

    public void activateObject(Object object, Object object2) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingMap.containsKey(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject((Object)pooledConnectionAndInfo.getUserPassKey(), (Object)pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                try {
                    this.destroyObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        try {
            if (null != connectionEvent.getSQLException()) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
            }
            pooledConnection.removeConnectionEventListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.destroyObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }
}

