/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;

abstract class InstanceKeyObjectFactory
implements ObjectFactory {
    private static Map instanceMap = new HashMap();

    InstanceKeyObjectFactory() {
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource instanceKeyDataSource) {
        Object object;
        int n = 0;
        Iterator iterator = instanceMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof String)) continue;
            try {
                n = Math.max(n, Integer.valueOf((String)object));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        object = String.valueOf(n + 1);
        instanceMap.put(object, instanceKeyDataSource);
        return object;
    }

    static void removeInstance(String string) {
        instanceMap.remove(string);
    }

    public static void closeAll() throws Exception {
        Iterator iterator = instanceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ((InstanceKeyDataSource)iterator.next().getValue()).close();
        }
        instanceMap.clear();
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws IOException, ClassNotFoundException {
        Reference reference;
        InstanceKeyDataSource instanceKeyDataSource = null;
        if (object instanceof Reference && this.isCorrectClass((reference = (Reference)object).getClassName())) {
            RefAddr refAddr = reference.get("instanceKey");
            if (refAddr != null && refAddr.getContent() != null) {
                instanceKeyDataSource = (InstanceKeyDataSource)instanceMap.get(refAddr.getContent());
            } else {
                String string = null;
                if (name != null) {
                    string = name.toString();
                    instanceKeyDataSource = (InstanceKeyDataSource)instanceMap.get(string);
                }
                if (instanceKeyDataSource == null) {
                    InstanceKeyDataSource instanceKeyDataSource2 = this.getNewInstance(reference);
                    this.setCommonProperties(reference, instanceKeyDataSource2);
                    instanceKeyDataSource = instanceKeyDataSource2;
                    if (string != null) {
                        instanceMap.put(string, instanceKeyDataSource2);
                    }
                }
            }
        }
        return instanceKeyDataSource;
    }

    private void setCommonProperties(Reference reference, InstanceKeyDataSource instanceKeyDataSource) throws IOException, ClassNotFoundException {
        RefAddr refAddr = reference.get("dataSourceName");
        if (refAddr != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDataSourceName(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("defaultAutoCommit")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultAutoCommit(Boolean.valueOf(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultReadOnly")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultReadOnly(Boolean.valueOf(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("description")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDescription(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("jndiEnvironment")) != null && refAddr.getContent() != null) {
            byte[] byArray = (byte[])refAddr.getContent();
            instanceKeyDataSource.jndiEnvironment = (Properties)InstanceKeyObjectFactory.deserialize(byArray);
        }
        if ((refAddr = reference.get("loginTimeout")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setLoginTimeout(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testOnBorrow")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setTestOnBorrow(Boolean.getBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testOnReturn")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setTestOnReturn(Boolean.valueOf(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("timeBetweenEvictionRunsMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setTimeBetweenEvictionRunsMillis(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("numTestsPerEvictionRun")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setNumTestsPerEvictionRun(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("minEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setMinEvictableIdleTimeMillis(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("testWhileIdle")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setTestWhileIdle(Boolean.valueOf(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("validationQuery")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setValidationQuery(refAddr.getContent().toString());
        }
    }

    protected abstract boolean isCorrectClass(String var1);

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object;
        block5: {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                object = objectInputStream.readObject();
                Object var4_3 = null;
                if (objectInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (objectInputStream == null) break block6;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }
}

