/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable {
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private boolean getConnectionCalled = false;
    private ConnectionPoolDataSource cpds = null;
    private String dataSourceName = null;
    private boolean defaultAutoCommit = true;
    private int defaultTransactionIsolation = -1;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int maxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    private boolean defaultReadOnly = false;
    private String description = null;
    Properties jndiEnvironment = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private int _timeBetweenEvictionRunsMillis = (int)Math.min(Integer.MAX_VALUE, -1L);
    private int _numTestsPerEvictionRun = 3;
    private int _minEvictableIdleTimeMillis = (int)Math.min(Integer.MAX_VALUE, 1800000L);
    private boolean _testWhileIdle = false;
    private String validationQuery = null;
    private boolean rollbackAfterValidation = false;
    private boolean testPositionSet = false;
    protected String instanceKey = null;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public abstract void close() throws Exception;

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.cpds;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.cpds != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.cpds = connectionPoolDataSource;
        this.instanceKey = InstanceKeyObjectFactory.registerNewInstance(this);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.assertInitializationAllowed();
        if (this.cpds != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = string;
        this.instanceKey = InstanceKeyObjectFactory.registerNewInstance(this);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = bl;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = bl;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.assertInitializationAllowed();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getJndiEnvironment(String string) {
        String string2 = null;
        if (this.jndiEnvironment != null) {
            string2 = this.jndiEnvironment.getProperty(string);
        }
        return string2;
    }

    public void setJndiEnvironment(String string, String string2) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(string, string2);
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(System.out);
        }
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public final boolean isTestOnBorrow() {
        return this.getTestOnBorrow();
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this.assertInitializationAllowed();
        this._testOnBorrow = bl;
        this.testPositionSet = true;
    }

    public final boolean isTestOnReturn() {
        return this.getTestOnReturn();
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this.assertInitializationAllowed();
        this._testOnReturn = bl;
        this.testPositionSet = true;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int n) {
        this.assertInitializationAllowed();
        this._timeBetweenEvictionRunsMillis = n;
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this._numTestsPerEvictionRun = n;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        this.assertInitializationAllowed();
        this._minEvictableIdleTimeMillis = n;
    }

    public final boolean isTestWhileIdle() {
        return this.getTestWhileIdle();
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean bl) {
        this.assertInitializationAllowed();
        this._testWhileIdle = bl;
        this.testPositionSet = true;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.assertInitializationAllowed();
        this.validationQuery = string;
        if (!this.testPositionSet) {
            this.setTestOnBorrow(true);
        }
    }

    public boolean isRollbackAfterValidation() {
        return this.rollbackAfterValidation;
    }

    public void setRollbackAfterValidation(boolean bl) {
        this.assertInitializationAllowed();
        this.rollbackAfterValidation = bl;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLNestedException("Cannot borrow connection from pool", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw runtimeException;
        }
        catch (SQLException sQLException) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw sQLException;
        }
        catch (Exception exception) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLNestedException("Cannot borrow connection from pool", exception);
        }
        if (!(null != string2 ? string2.equals(pooledConnectionAndInfo.getPassword()) : null == pooledConnectionAndInfo.getPassword())) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLException("Given password did not match password used to create the PooledConnection.");
        }
        Connection connection = pooledConnectionAndInfo.getPooledConnection().getConnection();
        this.setupDefaults(connection, string);
        connection.clearWarnings();
        return connection;
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo pooledConnectionAndInfo) {
        if (pooledConnectionAndInfo != null) {
            try {
                pooledConnectionAndInfo.getPooledConnection().getConnection().close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ConnectionPoolDataSource testCPDS(String string, String string2) throws NamingException, SQLException {
        Object object;
        ConnectionPoolDataSource connectionPoolDataSource = this.cpds;
        if (connectionPoolDataSource == null) {
            object = null;
            object = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object object2 = object.lookup(this.dataSourceName);
            if (!(object2 instanceof ConnectionPoolDataSource)) throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + object2.getClass().getName() + ")" + " doesn't implement javax.sql.ConnectionPoolDataSource");
            connectionPoolDataSource = (ConnectionPoolDataSource)object2;
        }
        object = null;
        try {
            object = string != null ? connectionPoolDataSource.getPooledConnection(string, string2) : connectionPoolDataSource.getPooledConnection();
            if (object == null) {
                throw new SQLException("Cannot connect using the supplied username/password");
            }
            Object var7_6 = null;
            if (object == null) return connectionPoolDataSource;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (object == null) throw throwable;
            try {
                object.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            object.close();
            return connectionPoolDataSource;
        }
        catch (SQLException sQLException) {}
        return connectionPoolDataSource;
    }

    protected byte whenExhaustedAction(int n, int n2) {
        byte by = 1;
        if (n <= 0) {
            by = 2;
        } else if (n2 == 0) {
            by = 0;
        }
        return by;
    }

    public Reference getReference() throws NamingException {
        String string = this.getClass().getName();
        String string2 = string + "Factory";
        Reference reference = new Reference(string, string2, null);
        reference.add(new StringRefAddr("instanceKey", this.instanceKey));
        return reference;
    }
}

