/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected boolean _rollbackAfterValidation = false;
    protected ObjectPool _pool = null;
    protected String _username = null;
    protected String _password = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool objectPool, String string, String string2, String string3) {
        this._cpds = connectionPoolDataSource;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._validationQuery = string;
        this._username = string2;
        this._password = string3;
    }

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool objectPool, String string, boolean bl, String string2, String string3) {
        this(connectionPoolDataSource, objectPool, string, string2, string3);
        this._rollbackAfterValidation = bl;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource connectionPoolDataSource) {
        this._cpds = connectionPoolDataSource;
    }

    public synchronized void setValidationQuery(String string) {
        this._validationQuery = string;
    }

    public synchronized void setRollbackAfterValidation(boolean bl) {
        this._rollbackAfterValidation = bl;
    }

    public synchronized void setPool(ObjectPool objectPool) throws SQLException {
        if (null != this._pool && objectPool != this._pool) {
            try {
                this._pool.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot set the pool on this factory", exception);
            }
        }
        this._pool = objectPool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() {
        PooledConnectionAndInfo pooledConnectionAndInfo;
        try {
            PooledConnection pooledConnection = null;
            pooledConnection = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            pooledConnection.addConnectionEventListener(this);
            pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this._username, this._password);
            this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
        return pooledConnectionAndInfo;
    }

    public void destroyObject(Object object) throws Exception {
        if (object instanceof PooledConnectionAndInfo) {
            ((PooledConnectionAndInfo)object).getPooledConnection().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean validateObject(Object object) {
        boolean bl;
        block31: {
            bl = false;
            if (object instanceof PooledConnectionAndInfo) {
                PooledConnection pooledConnection = ((PooledConnectionAndInfo)object).getPooledConnection();
                String string = this._validationQuery;
                if (null != string) {
                    Throwable throwable2222;
                    ResultSet resultSet;
                    Statement statement;
                    Connection connection;
                    block28: {
                        block27: {
                            connection = null;
                            statement = null;
                            resultSet = null;
                            this.validatingMap.put(pooledConnection, null);
                            connection = pooledConnection.getConnection();
                            statement = connection.createStatement();
                            resultSet = statement.executeQuery(string);
                            bl = resultSet.next();
                            if (!this._rollbackAfterValidation) break block27;
                            connection.rollback();
                        }
                        Object var10_8 = null;
                        if (resultSet == null) break block28;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2222) {
                            // empty catch block
                        }
                    }
                    this.validatingMap.remove(pooledConnection);
                    {
                        break block31;
                        catch (Exception exception) {
                            Throwable throwable32222;
                            bl = false;
                            Object var10_9 = null;
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable32222) {
                                    // empty catch block
                                }
                            }
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable32222) {
                                    // empty catch block
                                }
                            }
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable32222) {
                                    // empty catch block
                                }
                            }
                            this.validatingMap.remove(pooledConnection);
                            break block31;
                        }
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable52222;
                        Object var10_10 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable52222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable52222) {
                                // empty catch block
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable52222) {
                                // empty catch block
                            }
                        }
                        this.validatingMap.remove(pooledConnection);
                        throw throwable4;
                    }
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void passivateObject(Object object) {
    }

    public void activateObject(Object object) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingMap.containsKey(pooledConnection)) {
            Object v = this.pcMap.get(pooledConnection);
            if (v == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(v);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                try {
                    this.destroyObject(v);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + v);
                    exception2.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        try {
            if (null != connectionEvent.getSQLException()) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
            }
            pooledConnection.removeConnectionEventListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object v = this.pcMap.get(pooledConnection);
        if (v == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.destroyObject(v);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + v);
            exception.printStackTrace();
        }
    }
}

