/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.cpdsadapter.ConnectionImpl;
import org.apache.commons.dbcp.cpdsadapter.PoolablePreparedStatementStub;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class PooledConnectionImpl
implements PooledConnection,
KeyedPoolableObjectFactory {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection = null;
    private DelegatingConnection delegatingConnection = null;
    private Connection logicalConnection = null;
    private Vector eventListeners;
    boolean isClosed;
    protected KeyedObjectPool pstmtPool = null;

    PooledConnectionImpl(Connection connection, KeyedObjectPool keyedObjectPool) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection)connection : new DelegatingConnection(connection);
        this.eventListeners = new Vector();
        this.isClosed = false;
        if (keyedObjectPool != null) {
            this.pstmtPool = keyedObjectPool;
            this.pstmtPool.setFactory((KeyedPoolableObjectFactory)this);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.eventListeners.contains(connectionEventListener)) {
            this.eventListeners.add(connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() throws SQLException {
        this.assertOpen();
        this.isClosed = true;
        if (this.pstmtPool != null) {
            try {
                this.pstmtPool.close();
            }
            finally {
                this.pstmtPool = null;
            }
        }
        Object var3_4 = null;
        try {
            this.connection.close();
        }
        finally {
            this.connection = null;
        }
        {
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot close connection (return to pool failed)", exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
            throw throwable;
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, withoutits previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection);
        return this.logicalConnection;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.eventListeners.remove(connectionEventListener);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, withoutits last Connection being closed.");
        }
    }

    void notifyListeners() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        Iterator iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionEventListener)iterator.next()).connectionClosed(connectionEvent);
        }
    }

    PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n, n2);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    protected Object createKey(String string, int n, int n2) {
        return new PStmtKey(this.normalizeSQL(string), n, n2);
    }

    protected Object createKey(String string) {
        return new PStmtKey(this.normalizeSQL(string));
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    public Object makeObject(Object object) throws Exception {
        if (null == object || !(object instanceof PStmtKey)) {
            throw new IllegalArgumentException();
        }
        PStmtKey pStmtKey = (PStmtKey)object;
        if (null == pStmtKey._resultSetType && null == pStmtKey._resultSetConcurrency) {
            return new PoolablePreparedStatementStub(this.connection.prepareStatement(pStmtKey._sql), pStmtKey, this.pstmtPool, this.delegatingConnection);
        }
        return new PoolablePreparedStatementStub(this.connection.prepareStatement(pStmtKey._sql, pStmtKey._resultSetType, pStmtKey._resultSetConcurrency), pStmtKey, this.pstmtPool, this.delegatingConnection);
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        if (object2 instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)object2).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)object2).close();
        }
    }

    public boolean validateObject(Object object, Object object2) {
        return true;
    }

    public void activateObject(Object object, Object object2) throws Exception {
        ((PoolablePreparedStatementStub)object2).activate();
    }

    public void passivateObject(Object object, Object object2) throws Exception {
        ((PreparedStatement)object2).clearParameters();
        ((PoolablePreparedStatementStub)object2).passivate();
    }

    class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;

        PStmtKey(String string) {
            this._sql = string;
        }

        PStmtKey(String string, int n, int n2) {
            this._sql = string;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        public boolean equals(Object object) {
            try {
                PStmtKey pStmtKey = (PStmtKey)object;
                return (null == this._sql && null == pStmtKey._sql || this._sql.equals(pStmtKey._sql)) && (null == this._resultSetType && null == pStmtKey._resultSetType || this._resultSetType.equals(pStmtKey._resultSetType)) && (null == this._resultSetConcurrency && null == pStmtKey._resultSetConcurrency || this._resultSetConcurrency.equals(pStmtKey._resultSetConcurrency));
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public int hashCode() {
            return null == this._sql ? 0 : this._sql.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PStmtKey: sql=");
            stringBuffer.append(this._sql);
            stringBuffer.append(", resultSetType=");
            stringBuffer.append(this._resultSetType);
            stringBuffer.append(", resultSetConcurrency=");
            stringBuffer.append(this._resultSetConcurrency);
            return stringBuffer.toString();
        }
    }
}

