/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.cpdsadapter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.cpdsadapter.PooledConnectionImpl;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class DriverAdapterCPDS
implements ConnectionPoolDataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static final String GET_CONNECTION_CALLED = "A PooledConnection was already requested from this source, further initialization is not allowed.";
    private String description;
    private String password;
    private String url;
    private String user;
    private String driver;
    private int loginTimeout;
    private PrintWriter logWriter = null;
    private boolean poolPreparedStatements;
    private int maxActive = 10;
    private int maxIdle = 10;
    private int _timeBetweenEvictionRunsMillis = -1;
    private int _numTestsPerEvictionRun = -1;
    private int _minEvictableIdleTimeMillis = -1;
    private int _maxPreparedStatements = -1;
    private boolean getConnectionCalled = false;

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.getConnectionCalled = true;
        GenericKeyedObjectPool genericKeyedObjectPool = null;
        if (this.isPoolPreparedStatements()) {
            genericKeyedObjectPool = this.getMaxPreparedStatements() <= 0 ? new GenericKeyedObjectPool(null, this.getMaxActive(), 2, 0L, this.getMaxIdle(), false, false, (long)this.getTimeBetweenEvictionRunsMillis(), this.getNumTestsPerEvictionRun(), (long)this.getMinEvictableIdleTimeMillis(), false) : new GenericKeyedObjectPool(null, this.getMaxActive(), 2, 0L, this.getMaxIdle(), this.getMaxPreparedStatements(), false, false, -1L, 0, 0L, false);
        }
        try {
            return new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), string, string2), (KeyedObjectPool)genericKeyedObjectPool);
        }
        catch (ClassCircularityError classCircularityError) {
            return new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), string, string2), (KeyedObjectPool)genericKeyedObjectPool);
        }
    }

    public Reference getReference() throws NamingException {
        String string = this.getClass().getName();
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("driver", this.getDriver()));
        reference.add(new StringRefAddr("loginTimeout", String.valueOf(this.getLoginTimeout())));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("url", this.getUrl()));
        reference.add(new StringRefAddr("poolPreparedStatements", String.valueOf(this.isPoolPreparedStatements())));
        reference.add(new StringRefAddr("maxActive", String.valueOf(this.getMaxActive())));
        reference.add(new StringRefAddr("maxIdle", String.valueOf(this.getMaxIdle())));
        reference.add(new StringRefAddr("timeBetweenEvictionRunsMillis", String.valueOf(this.getTimeBetweenEvictionRunsMillis())));
        reference.add(new StringRefAddr("numTestsPerEvictionRun", String.valueOf(this.getNumTestsPerEvictionRun())));
        reference.add(new StringRefAddr("minEvictableIdleTimeMillis", String.valueOf(this.getMinEvictableIdleTimeMillis())));
        reference.add(new StringRefAddr("maxPreparedStatements", String.valueOf(this.getMaxPreparedStatements())));
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference;
        DriverAdapterCPDS driverAdapterCPDS = null;
        if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(this.getClass().getName())) {
            RefAddr refAddr = reference.get("description");
            if (refAddr != null && refAddr.getContent() != null) {
                this.setDescription(refAddr.getContent().toString());
            }
            if ((refAddr = reference.get("driver")) != null && refAddr.getContent() != null) {
                this.setDriver(refAddr.getContent().toString());
            }
            if ((refAddr = reference.get("url")) != null && refAddr.getContent() != null) {
                this.setUrl(refAddr.getContent().toString());
            }
            if ((refAddr = reference.get("user")) != null && refAddr.getContent() != null) {
                this.setUser(refAddr.getContent().toString());
            }
            if ((refAddr = reference.get("password")) != null && refAddr.getContent() != null) {
                this.setPassword(refAddr.getContent().toString());
            }
            if ((refAddr = reference.get("poolPreparedStatements")) != null && refAddr.getContent() != null) {
                this.setPoolPreparedStatements(Boolean.getBoolean(refAddr.getContent().toString()));
            }
            if ((refAddr = reference.get("maxActive")) != null && refAddr.getContent() != null) {
                this.setMaxActive(Integer.parseInt(refAddr.getContent().toString()));
            }
            if ((refAddr = reference.get("maxIdle")) != null && refAddr.getContent() != null) {
                this.setMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
            }
            if ((refAddr = reference.get("timeBetweenEvictionRunsMillis")) != null && refAddr.getContent() != null) {
                this.setTimeBetweenEvictionRunsMillis(Integer.parseInt(refAddr.getContent().toString()));
            }
            if ((refAddr = reference.get("numTestsPerEvictionRun")) != null && refAddr.getContent() != null) {
                this.setNumTestsPerEvictionRun(Integer.parseInt(refAddr.getContent().toString()));
            }
            if ((refAddr = reference.get("minEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
                this.setMinEvictableIdleTimeMillis(Integer.parseInt(refAddr.getContent().toString()));
            }
            if ((refAddr = reference.get("maxPreparedStatements")) != null && refAddr.getContent() != null) {
                this.setMaxPreparedStatements(Integer.parseInt(refAddr.getContent().toString()));
            }
            driverAdapterCPDS = this;
        }
        return driverAdapterCPDS;
    }

    private void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.assertInitializationAllowed();
        this.password = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.assertInitializationAllowed();
        this.url = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.assertInitializationAllowed();
        this.user = string;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) throws ClassNotFoundException {
        this.assertInitializationAllowed();
        this.driver = string;
        Class.forName(string);
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean bl) {
        this.assertInitializationAllowed();
        this.poolPreparedStatements = bl;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n) {
        this.assertInitializationAllowed();
        this.maxActive = n;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.maxIdle = n;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int n) {
        this.assertInitializationAllowed();
        this._timeBetweenEvictionRunsMillis = n;
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this._numTestsPerEvictionRun = n;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        this.assertInitializationAllowed();
        this._minEvictableIdleTimeMillis = n;
    }

    public int getMaxPreparedStatements() {
        return this._maxPreparedStatements;
    }

    public void setMaxPreparedStatements(int n) {
        this._maxPreparedStatements = n;
    }
}

