/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.dbcp.cpdsadapter.PooledConnectionImpl;

class ConnectionImpl
implements Connection {
    private static final String CLOSED = "Attempted to use Connection after closed() was called.";
    private Connection connection;
    private PooledConnectionImpl pooledConnection;
    boolean isClosed;

    ConnectionImpl(PooledConnectionImpl pooledConnectionImpl, Connection connection) {
        this.pooledConnection = pooledConnectionImpl;
        this.connection = connection;
        this.isClosed = false;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            throw new SQLException("A ConnectionImpl was finalized without being closed which will cause leakage of  PooledConnections from the ConnectionPool.");
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    public void clearWarnings() throws SQLException {
        this.assertOpen();
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.assertOpen();
        this.isClosed = true;
        this.pooledConnection.notifyListeners();
    }

    public void commit() throws SQLException {
        this.assertOpen();
        this.connection.commit();
    }

    public Statement createStatement() throws SQLException {
        this.assertOpen();
        return this.connection.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.assertOpen();
        return this.connection.createStatement(n, n2);
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertOpen();
        return this.connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.assertOpen();
        return this.connection.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertOpen();
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpen();
        return this.connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertOpen();
        return this.connection.getWarnings();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isReadOnly() throws SQLException {
        this.assertOpen();
        return this.connection.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.assertOpen();
        return this.connection.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.assertOpen();
        return this.pooledConnection.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.assertOpen();
        return this.pooledConnection.prepareStatement(string, n, n2);
    }

    public void rollback() throws SQLException {
        this.assertOpen();
        this.connection.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.assertOpen();
        this.connection.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.assertOpen();
        this.connection.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.assertOpen();
        this.connection.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.assertOpen();
        this.connection.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpen();
        this.connection.setTypeMap(map);
    }

    public int getHoldability() throws SQLException {
        this.assertOpen();
        return this.connection.getHoldability();
    }

    public void setHoldability(int n) throws SQLException {
        this.assertOpen();
        this.connection.setHoldability(n);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.assertOpen();
        return this.connection.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.assertOpen();
        return this.connection.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.connection.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.connection.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.assertOpen();
        return this.connection.createStatement(n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(string, stringArray);
    }
}

