/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.PoolablePreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements Connection,
KeyedPoolableObjectFactory {
    protected KeyedObjectPool _pstmtPool = null;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    public PoolingConnection(Connection connection, KeyedObjectPool keyedObjectPool) {
        super(connection);
        this._pstmtPool = keyedObjectPool;
    }

    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool keyedObjectPool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                keyedObjectPool.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot close connection", exception);
            }
        }
        this.getInnermostDelegate().close();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(string));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("MaxOpenPreparedStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("MaxOpenPreparedStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    protected Object createKey(String string, int n, int n2) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(string), string2, n, n2);
    }

    protected Object createKey(String string) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(string), string2);
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    public Object makeObject(Object object) throws Exception {
        if (null == object || !(object instanceof PStmtKey)) {
            throw new IllegalArgumentException();
        }
        PStmtKey pStmtKey = (PStmtKey)object;
        if (null == pStmtKey._resultSetType && null == pStmtKey._resultSetConcurrency) {
            return new PoolablePreparedStatement(this.getDelegate().prepareStatement(pStmtKey._sql), pStmtKey, this._pstmtPool, this);
        }
        return new PoolablePreparedStatement(this.getDelegate().prepareStatement(pStmtKey._sql, pStmtKey._resultSetType, pStmtKey._resultSetConcurrency), pStmtKey, this._pstmtPool, this);
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        if (object2 instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)object2).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)object2).close();
        }
    }

    public boolean validateObject(Object object, Object object2) {
        return true;
    }

    public void activateObject(Object object, Object object2) throws Exception {
        ((DelegatingPreparedStatement)object2).activate();
    }

    public void passivateObject(Object object, Object object2) throws Exception {
        ((PreparedStatement)object2).clearParameters();
        ((DelegatingPreparedStatement)object2).passivate();
    }

    public String toString() {
        return "PoolingConnection: " + this._pstmtPool.toString();
    }

    class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;
        protected String _catalog = null;

        PStmtKey(String string) {
            this._sql = string;
        }

        PStmtKey(String string, String string2) {
            this._sql = string;
            this._catalog = string2;
        }

        PStmtKey(String string, int n, int n2) {
            this._sql = string;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        PStmtKey(String string, String string2, int n, int n2) {
            this._sql = string;
            this._catalog = string2;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        public boolean equals(Object object) {
            try {
                PStmtKey pStmtKey = (PStmtKey)object;
                return (null == this._sql && null == pStmtKey._sql || this._sql.equals(pStmtKey._sql)) && (null == this._catalog && null == pStmtKey._catalog || this._catalog.equals(pStmtKey._catalog)) && (null == this._resultSetType && null == pStmtKey._resultSetType || this._resultSetType.equals(pStmtKey._resultSetType)) && (null == this._resultSetConcurrency && null == pStmtKey._resultSetConcurrency || this._resultSetConcurrency.equals(pStmtKey._resultSetConcurrency));
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public int hashCode() {
            if (this._catalog == null) {
                return null == this._sql ? 0 : this._sql.hashCode();
            }
            return null == this._sql ? this._catalog.hashCode() : (this._catalog + this._sql).hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PStmtKey: sql=");
            stringBuffer.append(this._sql);
            stringBuffer.append(", catalog=");
            stringBuffer.append(this._catalog);
            stringBuffer.append(", resultSetType=");
            stringBuffer.append(this._resultSetType);
            stringBuffer.append(", resultSetConcurrency=");
            stringBuffer.append(this._resultSetConcurrency);
            return stringBuffer.toString();
        }
    }
}

