/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;

public class PoolableConnection
extends DelegatingConnection {
    protected ObjectPool _pool = null;

    public PoolableConnection(Connection connection, ObjectPool objectPool) {
        super(connection);
        this._pool = objectPool;
    }

    public PoolableConnection(Connection connection, ObjectPool objectPool, AbandonedConfig abandonedConfig) {
        super(connection, abandonedConfig);
        this._pool = objectPool;
    }

    public synchronized void close() throws SQLException {
        boolean bl = false;
        try {
            bl = this.isClosed();
        }
        catch (SQLException sQLException) {
            try {
                this._pool.invalidateObject((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLNestedException("Cannot close connection (isClosed check failed)", sQLException);
        }
        if (bl) {
            try {
                this._pool.invalidateObject((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Already closed.");
        }
        try {
            this._pool.returnObject((Object)this);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Cannot close connection (return to pool failed)", exception);
        }
    }

    public void reallyClose() throws SQLException {
        super.close();
    }
}

