/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;

public class DelegatingCallableStatement
extends DelegatingPreparedStatement
implements CallableStatement {
    protected CallableStatement _stmt = null;

    public DelegatingCallableStatement(DelegatingConnection delegatingConnection, CallableStatement callableStatement) {
        super(delegatingConnection, callableStatement);
        this._stmt = callableStatement;
    }

    public boolean equals(Object object) {
        CallableStatement callableStatement = (CallableStatement)this.getInnermostDelegate();
        if (callableStatement == null) {
            return false;
        }
        if (object instanceof DelegatingCallableStatement) {
            DelegatingCallableStatement delegatingCallableStatement = (DelegatingCallableStatement)object;
            return callableStatement.equals(delegatingCallableStatement.getInnermostDelegate());
        }
        return callableStatement.equals(object);
    }

    public void setDelegate(CallableStatement callableStatement) {
        super.setDelegate(callableStatement);
        this._stmt = callableStatement;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.registerOutParameter(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.wasNull();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public String getString(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getString(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBoolean(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public byte getByte(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getByte(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public short getShort(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getShort(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public int getInt(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getInt(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getLong(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    public float getFloat(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFloat(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0f;
        }
    }

    public double getDouble(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getDouble(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBytes(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getDate(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTime(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getObject(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getObject(n, map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Ref getRef(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getRef(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBlob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Clob getClob(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getClob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Array getArray(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getArray(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.registerOutParameter(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.registerOutParameter(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.registerOutParameter(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.registerOutParameter(string, n, string2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public URL getURL(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getURL(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setURL(string, uRL);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setNull(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setNull(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setByte(String string, byte by) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setByte(string, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setShort(String string, short s) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setShort(string, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setInt(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setInt(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setLong(String string, long l) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setLong(string, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setFloat(String string, float f) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFloat(string, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setDouble(String string, double d) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setDouble(string, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setString(String string, String string2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setString(string, string2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setDate(String string, Date date) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setDate(string, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTime(String string, Time time) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setTime(string, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setObject(string, object, n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setObject(string, object, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setObject(String string, Object object) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setObject(string, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.checkOpen();
        this._stmt.setCharacterStream(string, reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setDate(string, date, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setTime(string, time, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setTimestamp(string, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setNull(string, n, string2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public String getString(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getString(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBoolean(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public byte getByte(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getByte(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public short getShort(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getShort(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public int getInt(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getInt(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public long getLong(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getLong(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    public float getFloat(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFloat(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0f;
        }
    }

    public double getDouble(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getDouble(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBytes(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getDate(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTime(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getObject(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getObject(string, map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Ref getRef(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getRef(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getBlob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Clob getClob(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getClob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Array getArray(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getArray(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public URL getURL(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getURL(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }
}

