/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    private static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    private static final String PROP_DRIVERCLASSNAME = "driverClassName";
    private static final String PROP_MAXACTIVE = "maxActive";
    private static final String PROP_MAXIDLE = "maxIdle";
    private static final String PROP_MINIDLE = "minIdle";
    private static final String PROP_INITIALSIZE = "initialSize";
    private static final String PROP_MAXWAIT = "maxWait";
    private static final String PROP_TESTONBORROW = "testOnBorrow";
    private static final String PROP_TESTONRETURN = "testOnReturn";
    private static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    private static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_VALIDATIONQUERY = "validationQuery";
    private static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVEABANDONED = "removeAbandoned";
    private static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOGABANDONED = "logAbandoned";
    private static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    private static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "password", "url", "username", "validationQuery", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties"};

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        if (!"javax.sql.DataSource".equals(reference.getClassName())) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
            String string = ALL_PROPERTIES[i];
            RefAddr refAddr = reference.get(string);
            if (refAddr == null) continue;
            String string2 = refAddr.getContent().toString();
            properties.setProperty(string, string2);
        }
        return BasicDataSourceFactory.createDataSource(properties);
    }

    public static DataSource createDataSource(Properties properties) throws Exception {
        BasicDataSource basicDataSource = new BasicDataSource();
        String string = null;
        string = properties.getProperty(PROP_DEFAULTAUTOCOMMIT);
        if (string != null) {
            basicDataSource.setDefaultAutoCommit(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULTREADONLY)) != null) {
            basicDataSource.setDefaultReadOnly(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULTTRANSACTIONISOLATION)) != null) {
            int n = -1;
            if ("NONE".equalsIgnoreCase(string)) {
                n = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(string)) {
                n = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(string)) {
                n = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(string)) {
                n = 8;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + string);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    n = -1;
                }
            }
            basicDataSource.setDefaultTransactionIsolation(n);
        }
        if ((string = properties.getProperty(PROP_DEFAULTCATALOG)) != null) {
            basicDataSource.setDefaultCatalog(string);
        }
        if ((string = properties.getProperty(PROP_DRIVERCLASSNAME)) != null) {
            basicDataSource.setDriverClassName(string);
        }
        if ((string = properties.getProperty(PROP_MAXACTIVE)) != null) {
            basicDataSource.setMaxActive(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAXIDLE)) != null) {
            basicDataSource.setMaxIdle(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MINIDLE)) != null) {
            basicDataSource.setMinIdle(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_INITIALSIZE)) != null) {
            basicDataSource.setInitialSize(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAXWAIT)) != null) {
            basicDataSource.setMaxWait(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_TESTONBORROW)) != null) {
            basicDataSource.setTestOnBorrow(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_TESTONRETURN)) != null) {
            basicDataSource.setTestOnReturn(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            basicDataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            basicDataSource.setNumTestsPerEvictionRun(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            basicDataSource.setMinEvictableIdleTimeMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_TESTWHILEIDLE)) != null) {
            basicDataSource.setTestWhileIdle(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_PASSWORD)) != null) {
            basicDataSource.setPassword(string);
        }
        if ((string = properties.getProperty(PROP_URL)) != null) {
            basicDataSource.setUrl(string);
        }
        if ((string = properties.getProperty(PROP_USERNAME)) != null) {
            basicDataSource.setUsername(string);
        }
        if ((string = properties.getProperty(PROP_VALIDATIONQUERY)) != null) {
            basicDataSource.setValidationQuery(string);
        }
        if ((string = properties.getProperty(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            basicDataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_REMOVEABANDONED)) != null) {
            basicDataSource.setRemoveAbandoned(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_REMOVEABANDONEDTIMEOUT)) != null) {
            basicDataSource.setRemoveAbandonedTimeout(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_LOGABANDONED)) != null) {
            basicDataSource.setLogAbandoned(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            basicDataSource.setPoolPreparedStatements(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
            basicDataSource.setMaxOpenPreparedStatements(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_CONNECTIONPROPERTIES)) != null) {
            Properties properties2 = BasicDataSourceFactory.getProperties(string);
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                basicDataSource.addConnectionProperty(string2, properties2.getProperty(string2));
            }
        }
        return basicDataSource;
    }

    private static Properties getProperties(String string) throws Exception {
        Properties properties = new Properties();
        if (string != null) {
            properties.load(new ByteArrayInputStream(string.replace(';', '\n').getBytes()));
        }
        return properties;
    }
}

