/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected boolean defaultAutoCommit = true;
    protected Boolean defaultReadOnly = null;
    protected int defaultTransactionIsolation = -1;
    protected String defaultCatalog = null;
    protected String driverClassName = null;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean poolPreparedStatements = false;
    protected int maxOpenPreparedStatements = -1;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;
    protected String password = null;
    protected String url = null;
    protected String username = null;
    protected String validationQuery = null;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private boolean restartNeeded = false;
    protected GenericObjectPool connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    private AbandonedConfig abandonedConfig;

    public synchronized boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public synchronized void setDefaultAutoCommit(boolean bl) {
        this.defaultAutoCommit = bl;
        this.restartNeeded = true;
    }

    public synchronized boolean getDefaultReadOnly() {
        if (this.defaultReadOnly != null) {
            return this.defaultReadOnly;
        }
        return false;
    }

    public synchronized void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this.restartNeeded = true;
    }

    public synchronized int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public synchronized void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
        this.restartNeeded = true;
    }

    public synchronized String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public synchronized void setDefaultCatalog(String string) {
        this.defaultCatalog = string != null && string.trim().length() > 0 ? string : null;
        this.restartNeeded = true;
    }

    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String string) {
        this.driverClassName = string != null && string.trim().length() > 0 ? string : null;
        this.restartNeeded = true;
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int n) {
        this.maxActive = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxActive(n);
        }
    }

    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int n) {
        this.maxIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(n);
        }
    }

    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int n) {
        this.minIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(n);
        }
    }

    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int n) {
        this.initialSize = n;
        this.restartNeeded = true;
    }

    public synchronized long getMaxWait() {
        return this.maxWait;
    }

    public synchronized void setMaxWait(long l) {
        this.maxWait = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWait(l);
        }
    }

    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setPoolPreparedStatements(boolean bl) {
        this.poolPreparedStatements = bl;
        this.restartNeeded = true;
    }

    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public synchronized void setMaxOpenPreparedStatements(int n) {
        this.maxOpenPreparedStatements = n;
        this.restartNeeded = true;
    }

    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(bl);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(bl);
        }
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this.timeBetweenEvictionRunsMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(l);
        }
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(n);
        }
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleTimeMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(l);
        }
    }

    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(bl);
        }
    }

    public synchronized int getNumActive() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumActive();
        }
        return 0;
    }

    public synchronized int getNumIdle() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumIdle();
        }
        return 0;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
        this.restartNeeded = true;
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String string) {
        this.url = string;
        this.restartNeeded = true;
    }

    public synchronized String getUsername() {
        return this.username;
    }

    public synchronized void setUsername(String string) {
        this.username = string;
        this.restartNeeded = true;
    }

    public synchronized String getValidationQuery() {
        return this.validationQuery;
    }

    public synchronized void setValidationQuery(String string) {
        this.validationQuery = string != null && string.trim().length() > 0 ? string : null;
        this.restartNeeded = true;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
        this.restartNeeded = true;
    }

    private synchronized boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public int getLoginTimeout() throws SQLException {
        return this.createDataSource().getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.createDataSource().setLoginTimeout(n);
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.createDataSource().setLogWriter(printWriter);
        this.logWriter = printWriter;
    }

    public boolean getRemoveAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandoned();
        }
        return false;
    }

    public void setRemoveAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandoned(bl);
        this.restartNeeded = true;
    }

    public int getRemoveAbandonedTimeout() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return 300;
    }

    public void setRemoveAbandonedTimeout(int n) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(n);
        this.restartNeeded = true;
    }

    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(bl);
        this.restartNeeded = true;
    }

    public void addConnectionProperty(String string, String string2) {
        this.connectionProperties.put(string, string2);
        this.restartNeeded = true;
    }

    public void removeConnectionProperty(String string) {
        this.connectionProperties.remove(string);
        this.restartNeeded = true;
    }

    public synchronized void close() throws SQLException {
        GenericObjectPool genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Cannot close connection pool", exception);
        }
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.driverClassName != null) {
            try {
                Class.forName(this.driverClassName);
            }
            catch (Throwable throwable) {
                String string = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                this.logWriter.println(string);
                throwable.printStackTrace(this.logWriter);
                throw new SQLNestedException(string, throwable);
            }
        }
        Driver driver = null;
        try {
            driver = DriverManager.getDriver(this.url);
        }
        catch (Throwable throwable) {
            String string = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(string);
            throwable.printStackTrace(this.logWriter);
            throw new SQLNestedException(string, throwable);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        this.connectionPool = this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandoned() ? new AbandonedObjectPool(null, this.abandonedConfig) : new GenericObjectPool();
        this.connectionPool.setMaxActive(this.maxActive);
        this.connectionPool.setMaxIdle(this.maxIdle);
        this.connectionPool.setMinIdle(this.minIdle);
        this.connectionPool.setMaxWait(this.maxWait);
        this.connectionPool.setTestOnBorrow(this.testOnBorrow);
        this.connectionPool.setTestOnReturn(this.testOnReturn);
        this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.connectionPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        this.connectionPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.connectionPool.setTestWhileIdle(this.testWhileIdle);
        GenericKeyedObjectPoolFactory genericKeyedObjectPoolFactory = null;
        if (this.isPoolPreparedStatements()) {
            genericKeyedObjectPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, this.maxOpenPreparedStatements);
        }
        if (this.username != null) {
            this.connectionProperties.put("user", this.username);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        if (this.password != null) {
            this.connectionProperties.put("password", this.password);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        PoolableConnectionFactory poolableConnectionFactory = null;
        try {
            poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverConnectionFactory, (ObjectPool)this.connectionPool, (KeyedObjectPoolFactory)genericKeyedObjectPoolFactory, this.validationQuery, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, this.abandonedConfig);
            if (poolableConnectionFactory == null) {
                throw new SQLException("Cannot create PoolableConnectionFactory");
            }
            BasicDataSource.validateConnectionFactory(poolableConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")", exception);
        }
        this.dataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        ((PoolingDataSource)this.dataSource).setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        this.dataSource.setLogWriter(this.logWriter);
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.connectionPool.addObject();
            }
        }
        catch (Exception exception) {
            throw new SQLNestedException("Error preloading the connection pool", exception);
        }
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateConnectionFactory(PoolableConnectionFactory poolableConnectionFactory) throws Exception {
        Connection connection = null;
        try {
            connection = (Connection)poolableConnectionFactory.makeObject();
            poolableConnectionFactory.activateObject(connection);
            poolableConnectionFactory.validateConnection(connection);
            poolableConnectionFactory.passivateObject(connection);
        }
        finally {
            poolableConnectionFactory.destroyObject(connection);
        }
    }

    private void restart() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            this.log("Could not restart DataSource, cause: " + sQLException.getMessage());
        }
    }

    private void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }
}

