/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;

public class AbandonedTrace {
    private static SimpleDateFormat format = new SimpleDateFormat("'DBCP object created' yyyy-MM-dd HH:mm:ss 'by the following code was never closed:'");
    private AbandonedConfig config = null;
    private AbandonedTrace parent;
    private Exception createdBy;
    private long createdTime;
    private List trace = new ArrayList();
    private long lastUsed = 0L;

    public AbandonedTrace() {
        this.init(this.parent);
    }

    public AbandonedTrace(AbandonedConfig abandonedConfig) {
        this.config = abandonedConfig;
        this.init(this.parent);
    }

    public AbandonedTrace(AbandonedTrace abandonedTrace) {
        this.config = abandonedTrace.getConfig();
        this.init(abandonedTrace);
    }

    private void init(AbandonedTrace abandonedTrace) {
        if (abandonedTrace != null) {
            abandonedTrace.addTrace(this);
        }
        if (this.config == null) {
            return;
        }
        if (this.config.getLogAbandoned()) {
            this.createdBy = new Exception();
            this.createdTime = System.currentTimeMillis();
        }
    }

    protected AbandonedConfig getConfig() {
        return this.config;
    }

    protected long getLastUsed() {
        if (this.parent != null) {
            return this.parent.getLastUsed();
        }
        return this.lastUsed;
    }

    protected void setLastUsed() {
        if (this.parent != null) {
            this.parent.setLastUsed();
        } else {
            this.lastUsed = System.currentTimeMillis();
        }
    }

    protected void setLastUsed(long l) {
        if (this.parent != null) {
            this.parent.setLastUsed(l);
        } else {
            this.lastUsed = l;
        }
    }

    protected void setStackTrace() {
        if (this.config == null) {
            return;
        }
        if (this.config.getLogAbandoned()) {
            this.createdBy = new Exception();
            this.createdTime = System.currentTimeMillis();
        }
        if (this.parent != null) {
            this.parent.addTrace(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrace(AbandonedTrace abandonedTrace) {
        AbandonedTrace abandonedTrace2 = this;
        synchronized (abandonedTrace2) {
            this.trace.add(abandonedTrace);
        }
        this.setLastUsed();
    }

    protected synchronized void clearTrace() {
        if (this.trace != null) {
            this.trace.clear();
        }
    }

    protected List getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        if (this.createdBy != null) {
            System.out.println(format.format(new Date(this.createdTime)));
            this.createdBy.printStackTrace(System.out);
        }
        AbandonedTrace abandonedTrace = this;
        synchronized (abandonedTrace) {
            Iterator iterator = this.trace.iterator();
            while (iterator.hasNext()) {
                AbandonedTrace abandonedTrace2 = (AbandonedTrace)iterator.next();
                abandonedTrace2.printStackTrace();
            }
        }
    }

    protected synchronized void removeTrace(AbandonedTrace abandonedTrace) {
        if (this.trace != null) {
            this.trace.remove(abandonedTrace);
        }
    }
}

