/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class AbandonedObjectPool
extends GenericObjectPool {
    private AbandonedConfig config = null;
    private List trace = new ArrayList();

    public AbandonedObjectPool(PoolableObjectFactory poolableObjectFactory, AbandonedConfig abandonedConfig) {
        super(poolableObjectFactory);
        this.config = abandonedConfig;
        System.out.println("AbandonedObjectPool is used (" + (Object)((Object)this) + ")");
        System.out.println("   LogAbandoned: " + abandonedConfig.getLogAbandoned());
        System.out.println("   RemoveAbandoned: " + abandonedConfig.getRemoveAbandoned());
        System.out.println("   RemoveAbandonedTimeout: " + abandonedConfig.getRemoveAbandonedTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        Object object;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((object = super.borrowObject()) instanceof AbandonedTrace) {
            ((AbandonedTrace)object).setStackTrace();
        }
        if (object != null && this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.add(object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean bl = this.trace.remove(object);
                if (!bl) {
                    return;
                }
            }
        }
        super.returnObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object object) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean bl = this.trace.remove(object);
                if (!bl) {
                    return;
                }
            }
        }
        super.invalidateObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        Object object;
        long l = System.currentTimeMillis();
        long l2 = l - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<AbandonedTrace> arrayList = new ArrayList<AbandonedTrace>();
        Object object2 = this.trace;
        synchronized (object2) {
            object = this.trace.iterator();
            while (object.hasNext()) {
                AbandonedTrace abandonedTrace = (AbandonedTrace)object.next();
                if (abandonedTrace.getLastUsed() > l2 || abandonedTrace.getLastUsed() <= 0L) continue;
                arrayList.add(abandonedTrace);
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (AbandonedTrace)object2.next();
            if (this.config.getLogAbandoned()) {
                ((AbandonedTrace)object).printStackTrace();
            }
            try {
                this.invalidateObject(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

