/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public abstract class AbstractSingleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected final AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = null;
        Class beanClass = this.getBeanClass(element);
        if (beanClass != null) {
            builder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        } else {
            String beanClassName = this.getBeanClassName(element);
            Assert.state(beanClassName != null, "Either 'getBeanClass' or 'getBeanClassName' must be overridden and return a non-null value");
            builder = BeanDefinitionBuilder.rootBeanDefinition(beanClassName);
        }
        builder.setSource(parserContext.extractSource(element));
        if (parserContext.isNested()) {
            builder.setSingleton(parserContext.getContainingBeanDefinition().isSingleton());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    protected Class getBeanClass(Element element) {
        return null;
    }

    protected String getBeanClassName(Element element) {
        return null;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.doParse(element, builder);
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
    }
}

