/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.util.ObjectUtils;

public abstract class BeanDefinitionVisitor {
    public void visitBeanDefinition(BeanDefinition beanDefinition) {
        this.visitBeanClassName(beanDefinition);
        this.visitScope(beanDefinition);
        this.visitPropertyValues(beanDefinition.getPropertyValues());
        ConstructorArgumentValues cas = beanDefinition.getConstructorArgumentValues();
        this.visitIndexedArgumentValues(cas.getIndexedArgumentValues());
        this.visitGenericArgumentValues(cas.getGenericArgumentValues());
    }

    protected void visitBeanClassName(BeanDefinition beanDefinition) {
        String resolvedName;
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClassName != null && !beanClassName.equals(resolvedName = this.resolveStringValue(beanClassName))) {
            beanDefinition.setBeanClassName(resolvedName);
        }
    }

    protected void visitScope(BeanDefinition beanDefinition) {
        String resolvedScope;
        String scope = beanDefinition.getScope();
        if (scope != null && !scope.equals(resolvedScope = this.resolveStringValue(scope))) {
            beanDefinition.setScope(resolvedScope);
        }
    }

    protected void visitPropertyValues(MutablePropertyValues pvs) {
        PropertyValue[] pvArray = pvs.getPropertyValues();
        for (int i = 0; i < pvArray.length; ++i) {
            PropertyValue pv = pvArray[i];
            Object newVal = this.resolveValue(pv.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, pv.getValue())) continue;
            pvs.addPropertyValue(pv.getName(), newVal);
        }
    }

    protected void visitIndexedArgumentValues(Map ias) {
        Iterator it = ias.values().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)it.next();
            Object newVal = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected void visitGenericArgumentValues(List gas) {
        Iterator it = gas.iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)it.next();
            Object newVal = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected Object resolveValue(Object value) {
        if (value instanceof BeanDefinition) {
            this.visitBeanDefinition((BeanDefinition)value);
        } else if (value instanceof BeanDefinitionHolder) {
            this.visitBeanDefinition(((BeanDefinitionHolder)value).getBeanDefinition());
        } else if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            String newBeanName = this.resolveStringValue(ref.getBeanName());
            if (!newBeanName.equals(ref.getBeanName())) {
                return new RuntimeBeanReference(newBeanName);
            }
        } else if (value instanceof List) {
            this.visitList((List)value);
        } else if (value instanceof Set) {
            this.visitSet((Set)value);
        } else if (value instanceof Map) {
            this.visitMap((Map)value);
        } else if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            String stringValue = typedStringValue.getValue();
            if (stringValue != null) {
                String visitedString = this.resolveStringValue(stringValue);
                typedStringValue.setValue(visitedString);
            }
        } else if (value instanceof String) {
            return this.resolveStringValue((String)value);
        }
        return value;
    }

    protected void visitList(List listVal) {
        for (int i = 0; i < listVal.size(); ++i) {
            Object elem = listVal.get(i);
            Object newVal = this.resolveValue(elem);
            if (ObjectUtils.nullSafeEquals(newVal, elem)) continue;
            listVal.set(i, newVal);
        }
    }

    protected void visitSet(Set setVal) {
        Iterator it = new HashSet(setVal).iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            Object newVal = this.resolveValue(elem);
            if (ObjectUtils.nullSafeEquals(newVal, elem)) continue;
            setVal.remove(elem);
            setVal.add(newVal);
        }
    }

    protected void visitMap(Map mapVal) {
        Iterator it = new HashMap(mapVal).entrySet().iterator();
        while (it.hasNext()) {
            Object newKey;
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            boolean isNewKey = !ObjectUtils.nullSafeEquals(key, newKey = this.resolveValue(key));
            Object val = entry.getValue();
            Object newVal = this.resolveValue(val);
            if (isNewKey) {
                mapVal.remove(key);
            }
            if (!isNewKey && ObjectUtils.nullSafeEquals(newVal, val)) continue;
            mapVal.put(newKey, newVal);
        }
    }

    protected abstract String resolveStringValue(String var1);
}

