/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class TransactionTemplate
extends DefaultTransactionDefinition
implements TransactionOperations,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PlatformTransactionManager transactionManager;

    public TransactionTemplate() {
    }

    public TransactionTemplate(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public TransactionTemplate(PlatformTransactionManager platformTransactionManager, TransactionDefinition transactionDefinition) {
        super(transactionDefinition);
        this.transactionManager = platformTransactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("Property 'transactionManager' is required");
        }
    }

    public Object execute(TransactionCallback transactionCallback) throws TransactionException {
        if (this.transactionManager instanceof CallbackPreferringPlatformTransactionManager) {
            return ((CallbackPreferringPlatformTransactionManager)this.transactionManager).execute(this, transactionCallback);
        }
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(this);
        Object object = null;
        try {
            object = transactionCallback.doInTransaction(transactionStatus);
        }
        catch (RuntimeException runtimeException) {
            this.rollbackOnException(transactionStatus, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.rollbackOnException(transactionStatus, error);
            throw error;
        }
        this.transactionManager.commit(transactionStatus);
        return object;
    }

    private void rollbackOnException(TransactionStatus transactionStatus, Throwable throwable) throws TransactionException {
        this.logger.debug((Object)"Initiating transaction rollback on application exception", throwable);
        try {
            this.transactionManager.rollback(transactionStatus);
        }
        catch (RuntimeException runtimeException) {
            this.logger.error((Object)"Application exception overridden by rollback exception", throwable);
            throw runtimeException;
        }
        catch (Error error) {
            this.logger.error((Object)"Application exception overridden by rollback error", throwable);
            throw error;
        }
    }
}

