/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class TransactionSynchronizationUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$support$TransactionSynchronizationUtils == null ? (class$org$springframework$transaction$support$TransactionSynchronizationUtils = TransactionSynchronizationUtils.class$("org.springframework.transaction.support.TransactionSynchronizationUtils")) : class$org$springframework$transaction$support$TransactionSynchronizationUtils));
    static /* synthetic */ Class class$org$springframework$transaction$support$TransactionSynchronizationUtils;

    public static void triggerBeforeCommit(boolean bl) {
        Iterator iterator = TransactionSynchronizationManager.getSynchronizations().iterator();
        while (iterator.hasNext()) {
            TransactionSynchronization transactionSynchronization = (TransactionSynchronization)iterator.next();
            transactionSynchronization.beforeCommit(bl);
        }
    }

    public static void triggerBeforeCompletion() {
        Iterator iterator = TransactionSynchronizationManager.getSynchronizations().iterator();
        while (iterator.hasNext()) {
            TransactionSynchronization transactionSynchronization = (TransactionSynchronization)iterator.next();
            try {
                transactionSynchronization.beforeCompletion();
            }
            catch (Throwable throwable) {
                logger.error((Object)"TransactionSynchronization.beforeCompletion threw exception", throwable);
            }
        }
    }

    public static void triggerAfterCommit() {
        List list = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCommit(list);
    }

    public static void invokeAfterCommit(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TransactionSynchronization transactionSynchronization = (TransactionSynchronization)iterator.next();
                try {
                    transactionSynchronization.afterCommit();
                }
                catch (AbstractMethodError abstractMethodError) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Spring 2.0's TransactionSynchronization.afterCommit method not implemented in synchronization class [" + transactionSynchronization.getClass().getName() + "]"), (Throwable)abstractMethodError);
                }
            }
        }
    }

    public static void triggerAfterCompletion(int n) {
        List list = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCompletion(list, n);
    }

    public static void invokeAfterCompletion(List list, int n) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TransactionSynchronization transactionSynchronization = (TransactionSynchronization)iterator.next();
                try {
                    transactionSynchronization.afterCompletion(n);
                }
                catch (Throwable throwable) {
                    logger.error((Object)"TransactionSynchronization.afterCompletion threw exception", throwable);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

