/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.OrderComparator;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.util.Assert;

public abstract class TransactionSynchronizationManager {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$support$TransactionSynchronizationManager == null ? (class$org$springframework$transaction$support$TransactionSynchronizationManager = TransactionSynchronizationManager.class$("org.springframework.transaction.support.TransactionSynchronizationManager")) : class$org$springframework$transaction$support$TransactionSynchronizationManager));
    private static final ThreadLocal resources = new ThreadLocal();
    private static final ThreadLocal synchronizations = new ThreadLocal();
    private static final Comparator synchronizationComparator = new OrderComparator();
    private static final ThreadLocal currentTransactionName = new ThreadLocal();
    private static final ThreadLocal currentTransactionReadOnly = new ThreadLocal();
    private static final ThreadLocal currentTransactionIsolationLevel = new ThreadLocal();
    private static final ThreadLocal actualTransactionActive = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$transaction$support$TransactionSynchronizationManager;

    public static Map getResourceMap() {
        Map map = (Map)resources.get();
        return map != null ? Collections.unmodifiableMap(map) : Collections.EMPTY_MAP;
    }

    public static boolean hasResource(Object object) {
        Assert.notNull((Object)object, (String)"Key must not be null");
        Map map = (Map)resources.get();
        return map != null && map.containsKey(object);
    }

    public static Object getResource(Object object) {
        Assert.notNull((Object)object, (String)"Key must not be null");
        Map map = (Map)resources.get();
        if (map == null) {
            return null;
        }
        Object v = map.get(object);
        if (v != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved value [" + v + "] for key [" + object + "] bound to thread [" + Thread.currentThread().getName() + "]"));
        }
        return v;
    }

    public static void bindResource(Object object, Object object2) throws IllegalStateException {
        Assert.notNull((Object)object, (String)"Key must not be null");
        Assert.notNull((Object)object2, (String)"Value must not be null");
        HashMap<Object, Object> hashMap = (HashMap<Object, Object>)resources.get();
        if (hashMap == null) {
            hashMap = new HashMap<Object, Object>();
            resources.set(hashMap);
        }
        if (hashMap.containsKey(object)) {
            throw new IllegalStateException("Already value [" + hashMap.get(object) + "] for key [" + object + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        hashMap.put(object, object2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound value [" + object2 + "] for key [" + object + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static Object unbindResource(Object object) throws IllegalStateException {
        Assert.notNull((Object)object, (String)"Key must not be null");
        Map map = (Map)resources.get();
        if (map == null || !map.containsKey(object)) {
            throw new IllegalStateException("No value for key [" + object + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        Object v = map.remove(object);
        if (map.isEmpty()) {
            resources.set(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed value [" + v + "] for key [" + object + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return v;
    }

    public static boolean isSynchronizationActive() {
        return synchronizations.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        logger.debug((Object)"Initializing transaction synchronization");
        synchronizations.set(new LinkedList());
    }

    public static void registerSynchronization(TransactionSynchronization transactionSynchronization) throws IllegalStateException {
        Assert.notNull((Object)transactionSynchronization, (String)"TransactionSynchronization must not be null");
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        List list = (List)synchronizations.get();
        list.add(transactionSynchronization);
    }

    public static List getSynchronizations() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        List list = (List)synchronizations.get();
        Collections.sort(list, synchronizationComparator);
        return Collections.unmodifiableList(new ArrayList(list));
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        logger.debug((Object)"Clearing transaction synchronization");
        synchronizations.set(null);
    }

    public static void setCurrentTransactionName(String string) {
        currentTransactionName.set(string);
    }

    public static String getCurrentTransactionName() {
        return (String)currentTransactionName.get();
    }

    public static void setCurrentTransactionReadOnly(boolean bl) {
        currentTransactionReadOnly.set(bl ? Boolean.TRUE : null);
    }

    public static boolean isCurrentTransactionReadOnly() {
        return currentTransactionReadOnly.get() != null;
    }

    public static void setCurrentTransactionIsolationLevel(Integer n) {
        currentTransactionIsolationLevel.set(n);
    }

    public static Integer getCurrentTransactionIsolationLevel() {
        return (Integer)currentTransactionIsolationLevel.get();
    }

    public static void setActualTransactionActive(boolean bl) {
        actualTransactionActive.set(bl ? Boolean.TRUE : null);
    }

    public static boolean isActualTransactionActive() {
        return actualTransactionActive.get() != null;
    }

    public static void clear() {
        TransactionSynchronizationManager.clearSynchronization();
        TransactionSynchronizationManager.setCurrentTransactionName(null);
        TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
        TransactionSynchronizationManager.setCurrentTransactionIsolationLevel(null);
        TransactionSynchronizationManager.setActualTransactionActive(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

