/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Date;
import org.springframework.transaction.TransactionTimedOutException;

public abstract class ResourceHolderSupport {
    private boolean synchronizedWithTransaction = false;
    private boolean rollbackOnly = false;
    private Date deadline;
    private int referenceCount = 0;

    public void setSynchronizedWithTransaction(boolean bl) {
        this.synchronizedWithTransaction = bl;
    }

    public boolean isSynchronizedWithTransaction() {
        return this.synchronizedWithTransaction;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setTimeoutInSeconds(int n) {
        this.setTimeoutInMillis(n * 1000);
    }

    public void setTimeoutInMillis(long l) {
        this.deadline = new Date(System.currentTimeMillis() + l);
    }

    public boolean hasTimeout() {
        return this.deadline != null;
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public int getTimeToLiveInSeconds() {
        double d = (double)this.getTimeToLiveInMillis() / 1000.0;
        int n = (int)Math.ceil(d);
        this.checkTransactionTimeout(n <= 0);
        return n;
    }

    public long getTimeToLiveInMillis() throws TransactionTimedOutException {
        if (this.deadline == null) {
            throw new IllegalStateException("No timeout specified for this resource holder");
        }
        long l = this.deadline.getTime() - System.currentTimeMillis();
        this.checkTransactionTimeout(l <= 0L);
        return l;
    }

    private void checkTransactionTimeout(boolean bl) throws TransactionTimedOutException {
        if (bl) {
            this.setRollbackOnly();
            throw new TransactionTimedOutException("Transaction timed out: deadline was " + this.deadline);
        }
    }

    public void requested() {
        ++this.referenceCount;
    }

    public void released() {
        --this.referenceCount;
    }

    public boolean isOpen() {
        return this.referenceCount > 0;
    }

    public void clear() {
        this.synchronizedWithTransaction = false;
        this.rollbackOnly = false;
        this.deadline = null;
    }

    public void reset() {
        this.clear();
        this.referenceCount = 0;
    }
}

