/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.support.AbstractTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;

public class DefaultTransactionStatus
extends AbstractTransactionStatus {
    private final Object transaction;
    private final boolean newTransaction;
    private final boolean newSynchronization;
    private final boolean readOnly;
    private final boolean debug;
    private final Object suspendedResources;

    public DefaultTransactionStatus(Object object, boolean bl, boolean bl2, boolean bl3, boolean bl4, Object object2) {
        this.transaction = object;
        this.newTransaction = bl;
        this.newSynchronization = bl2;
        this.readOnly = bl3;
        this.debug = bl4;
        this.suspendedResources = object2;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public boolean hasTransaction() {
        return this.transaction != null;
    }

    public boolean isNewTransaction() {
        return this.hasTransaction() && this.newTransaction;
    }

    public boolean isNewSynchronization() {
        return this.newSynchronization;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Object getSuspendedResources() {
        return this.suspendedResources;
    }

    public boolean isGlobalRollbackOnly() {
        return this.transaction instanceof SmartTransactionObject && ((SmartTransactionObject)this.transaction).isRollbackOnly();
    }

    protected SavepointManager getSavepointManager() {
        if (!this.isTransactionSavepointManager()) {
            throw new NestedTransactionNotSupportedException("Transaction object [" + this.getTransaction() + "] does not support savepoints");
        }
        return (SavepointManager)this.getTransaction();
    }

    public boolean isTransactionSavepointManager() {
        return this.getTransaction() instanceof SavepointManager;
    }
}

