/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.io.Serializable;
import org.springframework.core.Constants;
import org.springframework.transaction.TransactionDefinition;

public class DefaultTransactionDefinition
implements TransactionDefinition,
Serializable {
    public static final String PREFIX_PROPAGATION = "PROPAGATION_";
    public static final String PREFIX_ISOLATION = "ISOLATION_";
    public static final String PREFIX_TIMEOUT = "timeout_";
    public static final String READ_ONLY_MARKER = "readOnly";
    private static final Constants constants = new Constants(class$org$springframework$transaction$TransactionDefinition == null ? (class$org$springframework$transaction$TransactionDefinition = DefaultTransactionDefinition.class$("org.springframework.transaction.TransactionDefinition")) : class$org$springframework$transaction$TransactionDefinition);
    private int propagationBehavior = 0;
    private int isolationLevel = -1;
    private int timeout = -1;
    private boolean readOnly = false;
    private String name;
    static /* synthetic */ Class class$org$springframework$transaction$TransactionDefinition;

    public DefaultTransactionDefinition() {
    }

    public DefaultTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.propagationBehavior = transactionDefinition.getPropagationBehavior();
        this.isolationLevel = transactionDefinition.getIsolationLevel();
        this.timeout = transactionDefinition.getTimeout();
        this.readOnly = transactionDefinition.isReadOnly();
        this.name = transactionDefinition.getName();
    }

    public DefaultTransactionDefinition(int n) {
        this.propagationBehavior = n;
    }

    public final void setPropagationBehaviorName(String string) throws IllegalArgumentException {
        if (string == null || !string.startsWith(PREFIX_PROPAGATION)) {
            throw new IllegalArgumentException("Only propagation constants allowed");
        }
        this.setPropagationBehavior(constants.asNumber(string).intValue());
    }

    public final void setPropagationBehavior(int n) {
        if (!constants.getValues(PREFIX_PROPAGATION).contains(new Integer(n))) {
            throw new IllegalArgumentException("Only values of propagation constants allowed");
        }
        this.propagationBehavior = n;
    }

    public final int getPropagationBehavior() {
        return this.propagationBehavior;
    }

    public final void setIsolationLevelName(String string) throws IllegalArgumentException {
        if (string == null || !string.startsWith(PREFIX_ISOLATION)) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.setIsolationLevel(constants.asNumber(string).intValue());
    }

    public final void setIsolationLevel(int n) {
        if (!constants.getValues(PREFIX_ISOLATION).contains(new Integer(n))) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.isolationLevel = n;
    }

    public final int getIsolationLevel() {
        return this.isolationLevel;
    }

    public final void setTimeout(int n) {
        if (n < -1) {
            throw new IllegalArgumentException("Timeout must be a positive integer or TIMEOUT_DEFAULT");
        }
        this.timeout = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        return object instanceof TransactionDefinition && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getDefinitionDescription().toString();
    }

    protected final StringBuffer getDefinitionDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(constants.toCode((Object)new Integer(this.propagationBehavior), PREFIX_PROPAGATION));
        stringBuffer.append(',');
        stringBuffer.append(constants.toCode((Object)new Integer(this.isolationLevel), PREFIX_ISOLATION));
        if (this.timeout != -1) {
            stringBuffer.append(',');
            stringBuffer.append(PREFIX_TIMEOUT + this.timeout);
        }
        if (this.readOnly) {
            stringBuffer.append(',');
            stringBuffer.append(READ_ONLY_MARKER);
        }
        return stringBuffer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

