/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Constants;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;

public abstract class AbstractPlatformTransactionManager
implements PlatformTransactionManager,
Serializable {
    public static final int SYNCHRONIZATION_ALWAYS = 0;
    public static final int SYNCHRONIZATION_ON_ACTUAL_TRANSACTION = 1;
    public static final int SYNCHRONIZATION_NEVER = 2;
    private static final Constants constants = new Constants(class$org$springframework$transaction$support$AbstractPlatformTransactionManager == null ? (class$org$springframework$transaction$support$AbstractPlatformTransactionManager = AbstractPlatformTransactionManager.class$("org.springframework.transaction.support.AbstractPlatformTransactionManager")) : class$org$springframework$transaction$support$AbstractPlatformTransactionManager);
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private int transactionSynchronization = 0;
    private int defaultTimeout = -1;
    private boolean nestedTransactionAllowed = false;
    private boolean globalRollbackOnParticipationFailure = true;
    private boolean failEarlyOnGlobalRollbackOnly = false;
    private boolean rollbackOnCommitFailure = false;
    static /* synthetic */ Class class$org$springframework$transaction$support$AbstractPlatformTransactionManager;

    public final void setTransactionSynchronizationName(String string) {
        this.setTransactionSynchronization(constants.asNumber(string).intValue());
    }

    public final void setTransactionSynchronization(int n) {
        this.transactionSynchronization = n;
    }

    public final int getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    public final void setDefaultTimeout(int n) {
        if (n < -1) {
            throw new InvalidTimeoutException("Invalid default timeout", n);
        }
        this.defaultTimeout = n;
    }

    public final int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public final void setNestedTransactionAllowed(boolean bl) {
        this.nestedTransactionAllowed = bl;
    }

    public final boolean isNestedTransactionAllowed() {
        return this.nestedTransactionAllowed;
    }

    public final void setGlobalRollbackOnParticipationFailure(boolean bl) {
        this.globalRollbackOnParticipationFailure = bl;
    }

    public final boolean isGlobalRollbackOnParticipationFailure() {
        return this.globalRollbackOnParticipationFailure;
    }

    public final void setFailEarlyOnGlobalRollbackOnly(boolean bl) {
        this.failEarlyOnGlobalRollbackOnly = bl;
    }

    public final boolean isFailEarlyOnGlobalRollbackOnly() {
        return this.failEarlyOnGlobalRollbackOnly;
    }

    public final void setRollbackOnCommitFailure(boolean bl) {
        this.rollbackOnCommitFailure = bl;
    }

    public final boolean isRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    public final TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
        Object object = this.doGetTransaction();
        boolean bl = this.logger.isDebugEnabled();
        if (bl) {
            this.logger.debug((Object)("Using transaction object [" + object + "]"));
        }
        if (transactionDefinition == null) {
            transactionDefinition = new DefaultTransactionDefinition();
        }
        if (this.isExistingTransaction(object)) {
            return this.handleExistingTransaction(transactionDefinition, object, bl);
        }
        if (transactionDefinition.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", transactionDefinition.getTimeout());
        }
        if (transactionDefinition.getPropagationBehavior() == 2) {
            throw new IllegalTransactionStateException("No existing transaction found for transaction marked with propagation 'mandatory'");
        }
        if (transactionDefinition.getPropagationBehavior() == 0 || transactionDefinition.getPropagationBehavior() == 3 || transactionDefinition.getPropagationBehavior() == 6) {
            SuspendedResourcesHolder suspendedResourcesHolder = this.suspend(null);
            if (bl) {
                this.logger.debug((Object)("Creating new transaction with name [" + transactionDefinition.getName() + "]: " + transactionDefinition));
            }
            try {
                this.doBegin(object, transactionDefinition);
            }
            catch (TransactionException transactionException) {
                this.resume(null, suspendedResourcesHolder);
                throw transactionException;
            }
            boolean bl2 = this.getTransactionSynchronization() != 2;
            return this.newTransactionStatus(transactionDefinition, object, true, bl2, bl, suspendedResourcesHolder);
        }
        boolean bl3 = this.getTransactionSynchronization() == 0;
        return this.newTransactionStatus(transactionDefinition, null, true, bl3, bl, null);
    }

    private TransactionStatus handleExistingTransaction(TransactionDefinition transactionDefinition, Object object, boolean bl) throws TransactionException {
        if (transactionDefinition.getPropagationBehavior() == 5) {
            throw new IllegalTransactionStateException("Existing transaction found for transaction marked with propagation 'never'");
        }
        if (transactionDefinition.getPropagationBehavior() == 4) {
            if (bl) {
                this.logger.debug((Object)"Suspending current transaction");
            }
            SuspendedResourcesHolder suspendedResourcesHolder = this.suspend(object);
            boolean bl2 = this.getTransactionSynchronization() == 0;
            return this.newTransactionStatus(transactionDefinition, null, false, bl2, bl, suspendedResourcesHolder);
        }
        if (transactionDefinition.getPropagationBehavior() == 3) {
            if (bl) {
                this.logger.debug((Object)("Suspending current transaction, creating new transaction with name [" + transactionDefinition.getName() + "]"));
            }
            SuspendedResourcesHolder suspendedResourcesHolder = this.suspend(object);
            try {
                this.doBegin(object, transactionDefinition);
            }
            catch (TransactionException transactionException) {
                try {
                    this.resume(object, suspendedResourcesHolder);
                }
                catch (TransactionException transactionException2) {
                    this.logger.error((Object)"Inner transaction begin exception overridden by outer transaction resume exception", (Throwable)((Object)transactionException));
                    throw transactionException2;
                }
                throw transactionException;
            }
            boolean bl3 = this.getTransactionSynchronization() != 2;
            return this.newTransactionStatus(transactionDefinition, object, true, bl3, bl, suspendedResourcesHolder);
        }
        if (transactionDefinition.getPropagationBehavior() == 6) {
            if (!this.isNestedTransactionAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions by default - specify 'nestedTransactionAllowed' property with value 'true'");
            }
            if (bl) {
                this.logger.debug((Object)("Creating nested transaction with name [" + transactionDefinition.getName() + "]"));
            }
            if (this.useSavepointForNestedTransaction()) {
                DefaultTransactionStatus defaultTransactionStatus = this.newTransactionStatus(transactionDefinition, object, false, false, bl, null);
                defaultTransactionStatus.createAndHoldSavepoint();
                return defaultTransactionStatus;
            }
            this.doBegin(object, transactionDefinition);
            boolean bl4 = this.getTransactionSynchronization() != 2;
            return this.newTransactionStatus(transactionDefinition, object, true, bl4, bl, null);
        }
        if (bl) {
            this.logger.debug((Object)"Participating in existing transaction");
        }
        boolean bl5 = this.getTransactionSynchronization() != 2;
        return this.newTransactionStatus(transactionDefinition, object, false, bl5, bl, null);
    }

    protected DefaultTransactionStatus newTransactionStatus(TransactionDefinition transactionDefinition, Object object, boolean bl, boolean bl2, boolean bl3, Object object2) {
        boolean bl4;
        boolean bl5 = bl4 = bl2 && !TransactionSynchronizationManager.isSynchronizationActive();
        if (bl4) {
            TransactionSynchronizationManager.setActualTransactionActive(object != null);
            TransactionSynchronizationManager.setCurrentTransactionIsolationLevel(transactionDefinition.getIsolationLevel() != -1 ? new Integer(transactionDefinition.getIsolationLevel()) : null);
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(transactionDefinition.isReadOnly());
            TransactionSynchronizationManager.setCurrentTransactionName(transactionDefinition.getName());
            TransactionSynchronizationManager.initSynchronization();
        }
        return new DefaultTransactionStatus(object, bl, bl4, transactionDefinition.isReadOnly(), bl3, object2);
    }

    protected int determineTimeout(TransactionDefinition transactionDefinition) {
        if (transactionDefinition.getTimeout() != -1) {
            return transactionDefinition.getTimeout();
        }
        return this.defaultTimeout;
    }

    protected final SuspendedResourcesHolder suspend(Object object) throws TransactionException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            List list = this.doSuspendSynchronization();
            try {
                Object object2 = null;
                if (object != null) {
                    object2 = this.doSuspend(object);
                }
                String string = TransactionSynchronizationManager.getCurrentTransactionName();
                TransactionSynchronizationManager.setCurrentTransactionName(null);
                boolean bl = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
                Integer n = TransactionSynchronizationManager.getCurrentTransactionIsolationLevel();
                TransactionSynchronizationManager.setCurrentTransactionIsolationLevel(null);
                boolean bl2 = TransactionSynchronizationManager.isActualTransactionActive();
                TransactionSynchronizationManager.setActualTransactionActive(false);
                return new SuspendedResourcesHolder(object2, list, string, bl, n, bl2);
            }
            catch (TransactionException transactionException) {
                this.doResumeSynchronization(list);
                throw transactionException;
            }
        }
        if (object != null) {
            Object object3 = this.doSuspend(object);
            return new SuspendedResourcesHolder(object3);
        }
        return null;
    }

    protected final void resume(Object object, SuspendedResourcesHolder suspendedResourcesHolder) throws TransactionException {
        if (suspendedResourcesHolder != null) {
            List list;
            Object object2 = suspendedResourcesHolder.suspendedResources;
            if (object2 != null) {
                this.doResume(object, object2);
            }
            if ((list = suspendedResourcesHolder.suspendedSynchronizations) != null) {
                TransactionSynchronizationManager.setActualTransactionActive(suspendedResourcesHolder.wasActive);
                TransactionSynchronizationManager.setCurrentTransactionIsolationLevel(suspendedResourcesHolder.isolationLevel);
                TransactionSynchronizationManager.setCurrentTransactionReadOnly(suspendedResourcesHolder.readOnly);
                TransactionSynchronizationManager.setCurrentTransactionName(suspendedResourcesHolder.name);
                this.doResumeSynchronization(list);
            }
        }
    }

    private List doSuspendSynchronization() {
        List list = TransactionSynchronizationManager.getSynchronizations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((TransactionSynchronization)iterator.next()).suspend();
        }
        TransactionSynchronizationManager.clearSynchronization();
        return list;
    }

    private void doResumeSynchronization(List list) {
        TransactionSynchronizationManager.initSynchronization();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TransactionSynchronization transactionSynchronization = (TransactionSynchronization)iterator.next();
            transactionSynchronization.resume();
            TransactionSynchronizationManager.registerSynchronization(transactionSynchronization);
        }
    }

    public final void commit(TransactionStatus transactionStatus) throws TransactionException {
        if (transactionStatus.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        DefaultTransactionStatus defaultTransactionStatus = (DefaultTransactionStatus)transactionStatus;
        if (defaultTransactionStatus.isLocalRollbackOnly()) {
            if (defaultTransactionStatus.isDebug()) {
                this.logger.debug((Object)"Transactional code has requested rollback");
            }
            this.processRollback(defaultTransactionStatus);
            return;
        }
        if (!this.shouldCommitOnGlobalRollbackOnly() && defaultTransactionStatus.isGlobalRollbackOnly()) {
            if (defaultTransactionStatus.isDebug()) {
                this.logger.debug((Object)"Global transaction is marked as rollback-only but transactional code requested commit");
            }
            this.processRollback(defaultTransactionStatus);
            if (transactionStatus.isNewTransaction() || this.isFailEarlyOnGlobalRollbackOnly()) {
                throw new UnexpectedRollbackException("Transaction rolled back because it has been marked as rollback-only");
            }
            return;
        }
        this.processCommit(defaultTransactionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        try {
            boolean bl = false;
            try {
                this.triggerBeforeCommit(defaultTransactionStatus);
                this.triggerBeforeCompletion(defaultTransactionStatus);
                bl = true;
                boolean bl2 = false;
                if (defaultTransactionStatus.isNewTransaction() || this.isFailEarlyOnGlobalRollbackOnly()) {
                    bl2 = defaultTransactionStatus.isGlobalRollbackOnly();
                }
                if (defaultTransactionStatus.hasSavepoint()) {
                    if (defaultTransactionStatus.isDebug()) {
                        this.logger.debug((Object)"Releasing transaction savepoint");
                    }
                    defaultTransactionStatus.releaseHeldSavepoint();
                } else if (defaultTransactionStatus.isNewTransaction()) {
                    if (defaultTransactionStatus.isDebug()) {
                        this.logger.debug((Object)"Initiating transaction commit");
                    }
                    this.doCommit(defaultTransactionStatus);
                }
                if (bl2) {
                    throw new UnexpectedRollbackException("Transaction silently rolled back because it has been marked as rollback-only");
                }
            }
            catch (UnexpectedRollbackException unexpectedRollbackException) {
                this.triggerAfterCompletion(defaultTransactionStatus, 1);
                throw unexpectedRollbackException;
            }
            catch (TransactionException transactionException) {
                if (this.isRollbackOnCommitFailure()) {
                    this.doRollbackOnCommitException(defaultTransactionStatus, (Throwable)((Object)transactionException));
                } else {
                    this.triggerAfterCompletion(defaultTransactionStatus, 2);
                }
                throw transactionException;
            }
            catch (RuntimeException runtimeException) {
                if (!bl) {
                    this.triggerBeforeCompletion(defaultTransactionStatus);
                }
                this.doRollbackOnCommitException(defaultTransactionStatus, runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                if (!bl) {
                    this.triggerBeforeCompletion(defaultTransactionStatus);
                }
                this.doRollbackOnCommitException(defaultTransactionStatus, error);
                throw error;
            }
            try {
                this.triggerAfterCommit(defaultTransactionStatus);
            }
            finally {
                this.triggerAfterCompletion(defaultTransactionStatus, 0);
            }
        }
        finally {
            this.cleanupAfterCompletion(defaultTransactionStatus);
        }
    }

    public final void rollback(TransactionStatus transactionStatus) throws TransactionException {
        if (transactionStatus.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        DefaultTransactionStatus defaultTransactionStatus = (DefaultTransactionStatus)transactionStatus;
        this.processRollback(defaultTransactionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRollback(DefaultTransactionStatus defaultTransactionStatus) {
        try {
            try {
                this.triggerBeforeCompletion(defaultTransactionStatus);
                if (defaultTransactionStatus.hasSavepoint()) {
                    if (defaultTransactionStatus.isDebug()) {
                        this.logger.debug((Object)"Rolling back transaction to savepoint");
                    }
                    defaultTransactionStatus.rollbackToHeldSavepoint();
                } else if (defaultTransactionStatus.isNewTransaction()) {
                    if (defaultTransactionStatus.isDebug()) {
                        this.logger.debug((Object)"Initiating transaction rollback");
                    }
                    this.doRollback(defaultTransactionStatus);
                } else if (defaultTransactionStatus.hasTransaction()) {
                    if (defaultTransactionStatus.isLocalRollbackOnly() || this.isGlobalRollbackOnParticipationFailure()) {
                        if (defaultTransactionStatus.isDebug()) {
                            this.logger.debug((Object)"Participating transaction failed - marking existing transaction as rollback-only");
                        }
                        this.doSetRollbackOnly(defaultTransactionStatus);
                    } else if (defaultTransactionStatus.isDebug()) {
                        this.logger.debug((Object)"Participating transaction failed - letting transaction originator decide on rollback");
                    }
                } else {
                    this.logger.debug((Object)"Should roll back transaction but cannot - no transaction available");
                }
            }
            catch (RuntimeException runtimeException) {
                this.triggerAfterCompletion(defaultTransactionStatus, 2);
                throw runtimeException;
            }
            catch (Error error) {
                this.triggerAfterCompletion(defaultTransactionStatus, 2);
                throw error;
            }
            this.triggerAfterCompletion(defaultTransactionStatus, 1);
        }
        finally {
            this.cleanupAfterCompletion(defaultTransactionStatus);
        }
    }

    private void doRollbackOnCommitException(DefaultTransactionStatus defaultTransactionStatus, Throwable throwable) throws TransactionException {
        try {
            if (defaultTransactionStatus.isNewTransaction()) {
                if (defaultTransactionStatus.isDebug()) {
                    this.logger.debug((Object)"Initiating transaction rollback after commit exception", throwable);
                }
                this.doRollback(defaultTransactionStatus);
            } else if (defaultTransactionStatus.hasTransaction() && this.isGlobalRollbackOnParticipationFailure()) {
                if (defaultTransactionStatus.isDebug()) {
                    this.logger.debug((Object)"Marking existing transaction as rollback-only after commit exception", throwable);
                }
                this.doSetRollbackOnly(defaultTransactionStatus);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", throwable);
            this.triggerAfterCompletion(defaultTransactionStatus, 2);
            throw runtimeException;
        }
        catch (Error error) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", throwable);
            this.triggerAfterCompletion(defaultTransactionStatus, 2);
            throw error;
        }
        this.triggerAfterCompletion(defaultTransactionStatus, 1);
    }

    protected final void triggerBeforeCommit(DefaultTransactionStatus defaultTransactionStatus) {
        if (defaultTransactionStatus.isNewSynchronization()) {
            if (defaultTransactionStatus.isDebug()) {
                this.logger.debug((Object)"Triggering beforeCommit synchronization");
            }
            TransactionSynchronizationUtils.triggerBeforeCommit(defaultTransactionStatus.isReadOnly());
        }
    }

    protected final void triggerBeforeCompletion(DefaultTransactionStatus defaultTransactionStatus) {
        if (defaultTransactionStatus.isNewSynchronization()) {
            if (defaultTransactionStatus.isDebug()) {
                this.logger.debug((Object)"Triggering beforeCompletion synchronization");
            }
            TransactionSynchronizationUtils.triggerBeforeCompletion();
        }
    }

    private void triggerAfterCommit(DefaultTransactionStatus defaultTransactionStatus) {
        if (defaultTransactionStatus.isNewSynchronization()) {
            if (defaultTransactionStatus.isDebug()) {
                this.logger.debug((Object)"Triggering afterCommit synchronization");
            }
            TransactionSynchronizationUtils.triggerAfterCommit();
        }
    }

    private void triggerAfterCompletion(DefaultTransactionStatus defaultTransactionStatus, int n) {
        if (defaultTransactionStatus.isNewSynchronization()) {
            List list = TransactionSynchronizationManager.getSynchronizations();
            if (!defaultTransactionStatus.hasTransaction() || defaultTransactionStatus.isNewTransaction()) {
                if (defaultTransactionStatus.isDebug()) {
                    this.logger.debug((Object)"Triggering afterCompletion synchronization");
                }
                this.invokeAfterCompletion(list, n);
            } else {
                this.registerAfterCompletionWithExistingTransaction(defaultTransactionStatus.getTransaction(), list);
            }
        }
    }

    protected final void invokeAfterCompletion(List list, int n) {
        TransactionSynchronizationUtils.invokeAfterCompletion(list, n);
    }

    private void cleanupAfterCompletion(DefaultTransactionStatus defaultTransactionStatus) {
        defaultTransactionStatus.setCompleted();
        if (defaultTransactionStatus.isNewSynchronization()) {
            TransactionSynchronizationManager.clear();
        }
        if (defaultTransactionStatus.isNewTransaction()) {
            this.doCleanupAfterCompletion(defaultTransactionStatus.getTransaction());
        }
        if (defaultTransactionStatus.getSuspendedResources() != null) {
            if (defaultTransactionStatus.isDebug()) {
                this.logger.debug((Object)"Resuming suspended transaction");
            }
            this.resume(defaultTransactionStatus.getTransaction(), (SuspendedResourcesHolder)defaultTransactionStatus.getSuspendedResources());
        }
    }

    protected abstract Object doGetTransaction() throws TransactionException;

    protected boolean isExistingTransaction(Object object) throws TransactionException {
        return false;
    }

    protected boolean useSavepointForNestedTransaction() {
        return true;
    }

    protected abstract void doBegin(Object var1, TransactionDefinition var2) throws TransactionException;

    protected Object doSuspend(Object object) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected void doResume(Object object, Object object2) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return false;
    }

    protected abstract void doCommit(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doRollback(DefaultTransactionStatus var1) throws TransactionException;

    protected void doSetRollbackOnly(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        throw new IllegalTransactionStateException("Participating in existing transactions is not supported - when 'isExistingTransaction' returns true, appropriate 'doSetRollbackOnly' behavior must be provided");
    }

    protected void registerAfterCompletionWithExistingTransaction(Object object, List list) throws TransactionException {
        this.logger.debug((Object)"Cannot register Spring after-completion synchronization with existing transaction - processing Spring after-completion callbacks immediately, with outcome status 'unknown'");
        this.invokeAfterCompletion(list, 2);
    }

    protected void doCleanupAfterCompletion(Object object) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class SuspendedResourcesHolder {
        private final Object suspendedResources;
        private List suspendedSynchronizations;
        private String name;
        private boolean readOnly;
        private Integer isolationLevel;
        private boolean wasActive;

        private SuspendedResourcesHolder(Object object) {
            this.suspendedResources = object;
        }

        private SuspendedResourcesHolder(Object object, List list, String string, boolean bl, Integer n, boolean bl2) {
            this.suspendedResources = object;
            this.suspendedSynchronizations = list;
            this.name = string;
            this.readOnly = bl;
            this.isolationLevel = n;
            this.wasActive = bl2;
        }
    }
}

