/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.JtaTransactionObject;

public class WebLogicJtaTransactionManager
extends JtaTransactionManager {
    private static final String USER_TRANSACTION_CLASS_NAME = "weblogic.transaction.UserTransaction";
    private static final String CLIENT_TRANSACTION_MANAGER_CLASS_NAME = "weblogic.transaction.ClientTransactionManager";
    private static final String TRANSACTION_MANAGER_CLASS_NAME = "weblogic.transaction.TransactionManager";
    private static final String TRANSACTION_CLASS_NAME = "weblogic.transaction.Transaction";
    private static final String TRANSACTION_HELPER_CLASS_NAME = "weblogic.transaction.TransactionHelper";
    private static final String TX_HELPER_CLASS_NAME = "weblogic.transaction.TxHelper";
    private static final String ISOLATION_LEVEL_KEY = "ISOLATION LEVEL";
    private boolean weblogicUserTransactionAvailable;
    private Method beginWithNameMethod;
    private Method beginWithNameAndTimeoutMethod;
    private boolean weblogicTransactionManagerAvailable;
    private Method forceResumeMethod;
    private Method setPropertyMethod;
    private Class transactionHelperClass;
    private Object transactionHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$transaction$Transaction;
    static /* synthetic */ Class class$java$io$Serializable;

    public void afterPropertiesSet() throws TransactionSystemException {
        super.afterPropertiesSet();
        this.loadWebLogicTransactionClasses();
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        this.loadWebLogicTransactionHelperClass();
        try {
            this.logger.debug((Object)"Retrieving JTA UserTransaction from WebLogic TransactionHelper/TxHelper");
            Method method = this.transactionHelperClass.getMethod("getUserTransaction", new Class[0]);
            return (UserTransaction)method.invoke(this.transactionHelper, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransactionSystemException("WebLogic's TransactionHelper/TxHelper.getUserTransaction() method failed", invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new TransactionSystemException("Could not invoke WebLogic's TransactionHelper/TxHelper.getUserTransaction() method", exception);
        }
    }

    protected TransactionManager retrieveTransactionManager() throws TransactionSystemException {
        this.loadWebLogicTransactionHelperClass();
        try {
            this.logger.debug((Object)"Retrieving JTA TransactionManager from WebLogic TransactionHelper/TxHelper");
            Method method = this.transactionHelperClass.getMethod("getTransactionManager", new Class[0]);
            return (TransactionManager)method.invoke(this.transactionHelper, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransactionSystemException("WebLogic's TransactionHelper/TxHelper.getTransactionManager() method failed", invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new TransactionSystemException("Could not invoke WebLogic's TransactionHelper/TxHelper.getTransactionManager() method", exception);
        }
    }

    private void loadWebLogicTransactionHelperClass() throws TransactionSystemException {
        if (this.transactionHelperClass == null) {
            try {
                try {
                    this.transactionHelperClass = this.getClass().getClassLoader().loadClass(TRANSACTION_HELPER_CLASS_NAME);
                    Method method = this.transactionHelperClass.getMethod("getTransactionHelper", new Class[0]);
                    this.transactionHelper = method.invoke(null, new Object[0]);
                    this.logger.debug((Object)"WebLogic 8.1+ TransactionHelper found");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.transactionHelperClass = this.getClass().getClassLoader().loadClass(TX_HELPER_CLASS_NAME);
                    this.logger.debug((Object)"WebLogic 7.0 TxHelper found");
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TransactionSystemException("WebLogic's TransactionHelper.getTransactionHelper() method failed", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new TransactionSystemException("Could not initialize WebLogicJtaTransactionManager because WebLogic API classes are not available", exception);
            }
        }
    }

    private void loadWebLogicTransactionClasses() throws TransactionSystemException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(USER_TRANSACTION_CLASS_NAME);
            this.weblogicUserTransactionAvailable = clazz.isInstance(this.getUserTransaction());
            if (this.weblogicUserTransactionAvailable) {
                this.beginWithNameMethod = clazz.getMethod("begin", class$java$lang$String == null ? (class$java$lang$String = WebLogicJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String);
                this.beginWithNameAndTimeoutMethod = clazz.getMethod("begin", class$java$lang$String == null ? (class$java$lang$String = WebLogicJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                this.logger.info((Object)"Support for WebLogic transaction names available");
            } else {
                this.logger.info((Object)"Support for WebLogic transaction names not available");
            }
            Class<?> clazz2 = null;
            try {
                clazz2 = this.getClass().getClassLoader().loadClass(CLIENT_TRANSACTION_MANAGER_CLASS_NAME);
                this.logger.debug((Object)"WebLogic 8.1+ ClientTransactionManager found");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz2 = this.getClass().getClassLoader().loadClass(TRANSACTION_MANAGER_CLASS_NAME);
                this.logger.debug((Object)"WebLogic 7.0 TransactionManager found");
            }
            this.weblogicTransactionManagerAvailable = clazz2.isInstance(this.getTransactionManager());
            if (this.weblogicTransactionManagerAvailable) {
                Class<?> clazz3 = this.getClass().getClassLoader().loadClass(TRANSACTION_CLASS_NAME);
                this.forceResumeMethod = clazz2.getMethod("forceResume", class$javax$transaction$Transaction == null ? (class$javax$transaction$Transaction = WebLogicJtaTransactionManager.class$("javax.transaction.Transaction")) : class$javax$transaction$Transaction);
                this.setPropertyMethod = clazz3.getMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = WebLogicJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String, class$java$io$Serializable == null ? (class$java$io$Serializable = WebLogicJtaTransactionManager.class$("java.io.Serializable")) : class$java$io$Serializable);
                this.logger.debug((Object)"Support for WebLogic forceResume available");
            } else {
                this.logger.warn((Object)"Support for WebLogic forceResume not available");
            }
        }
        catch (Exception exception) {
            throw new TransactionSystemException("Could not initialize WebLogicJtaTransactionManager because WebLogic API classes are not available", exception);
        }
    }

    protected void doJtaBegin(JtaTransactionObject jtaTransactionObject, TransactionDefinition transactionDefinition) throws NotSupportedException, SystemException {
        int n = this.determineTimeout(transactionDefinition);
        if (this.weblogicUserTransactionAvailable && transactionDefinition.getName() != null) {
            try {
                if (n > -1) {
                    this.beginWithNameAndTimeoutMethod.invoke((Object)jtaTransactionObject.getUserTransaction(), transactionDefinition.getName(), new Integer(n));
                }
                this.beginWithNameMethod.invoke((Object)jtaTransactionObject.getUserTransaction(), transactionDefinition.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TransactionSystemException("WebLogic's UserTransaction.begin() method failed", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new TransactionSystemException("Could not invoke WebLogic's UserTransaction.begin() method", exception);
            }
        } else {
            this.applyTimeout(jtaTransactionObject, n);
            jtaTransactionObject.getUserTransaction().begin();
        }
        if (this.weblogicTransactionManagerAvailable) {
            if (transactionDefinition.getIsolationLevel() != -1) {
                try {
                    Transaction transaction = this.getTransactionManager().getTransaction();
                    Integer n2 = new Integer(transactionDefinition.getIsolationLevel());
                    this.setPropertyMethod.invoke((Object)transaction, ISOLATION_LEVEL_KEY, n2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new TransactionSystemException("WebLogic's Transaction.setProperty(String, Serializable) method failed", invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    throw new TransactionSystemException("Could not invoke WebLogic's Transaction.setProperty(String, Serializable) method", exception);
                }
            }
        } else {
            this.applyIsolationLevel(jtaTransactionObject, transactionDefinition.getIsolationLevel());
        }
    }

    protected void doJtaResume(JtaTransactionObject jtaTransactionObject, Object object) throws InvalidTransactionException, SystemException {
        try {
            this.getTransactionManager().resume((Transaction)object);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            if (!this.weblogicTransactionManagerAvailable) {
                throw invalidTransactionException;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Standard JTA resume threw InvalidTransactionException: " + invalidTransactionException.getMessage() + " - trying WebLogic JTA forceResume"));
            }
            try {
                this.forceResumeMethod.invoke((Object)this.getTransactionManager(), object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TransactionSystemException("WebLogic's TransactionManager.forceResume(Transaction) method failed", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new TransactionSystemException("Could not access WebLogic's TransactionManager.forceResume(Transaction) method", exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

