/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SpringJtaSynchronizationAdapter
implements Synchronization {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter == null ? (class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter = SpringJtaSynchronizationAdapter.class$("org.springframework.transaction.jta.SpringJtaSynchronizationAdapter")) : class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter));
    private final TransactionSynchronization springSynchronization;
    private UserTransaction jtaTransaction;
    private boolean beforeCompletionCalled = false;
    static /* synthetic */ Class class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter;

    public SpringJtaSynchronizationAdapter(TransactionSynchronization transactionSynchronization) {
        Assert.notNull((Object)transactionSynchronization, (String)"TransactionSynchronization must not be null");
        this.springSynchronization = transactionSynchronization;
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization transactionSynchronization, UserTransaction userTransaction) {
        this(transactionSynchronization);
        if (userTransaction != null && !userTransaction.getClass().getName().startsWith("weblogic.")) {
            this.jtaTransaction = userTransaction;
        }
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization transactionSynchronization, TransactionManager transactionManager) {
        this(transactionSynchronization);
        if (transactionManager != null && !transactionManager.getClass().getName().startsWith("weblogic.")) {
            this.jtaTransaction = new UserTransactionAdapter(transactionManager);
        }
    }

    public void beforeCompletion() {
        try {
            boolean bl = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            this.springSynchronization.beforeCommit(bl);
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnlyIfPossible();
            throw runtimeException;
        }
        catch (Error error) {
            this.setRollbackOnlyIfPossible();
            throw error;
        }
        finally {
            this.beforeCompletionCalled = true;
            this.springSynchronization.beforeCompletion();
        }
    }

    private void setRollbackOnlyIfPossible() {
        if (this.jtaTransaction != null) {
            try {
                this.jtaTransaction.setRollbackOnly();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.debug((Object)"JTA transaction handle does not support setRollbackOnly method - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion", (Throwable)unsupportedOperationException);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Could not set JTA transaction rollback-only", throwable);
            }
        } else {
            logger.debug((Object)"No JTA transaction handle available and/or running on WebLogic - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion");
        }
    }

    public void afterCompletion(int n) {
        if (!this.beforeCompletionCalled) {
            this.springSynchronization.beforeCompletion();
        }
        switch (n) {
            case 3: {
                this.springSynchronization.afterCompletion(0);
                break;
            }
            case 4: {
                this.springSynchronization.afterCompletion(1);
                break;
            }
            default: {
                this.springSynchronization.afterCompletion(2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

