/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.util.ClassUtils;

public class OC4JJtaTransactionManager
extends JtaTransactionManager {
    private static final String TRANSACTION_UTILITY_CLASS_NAME = "oracle.j2ee.transaction.TransactionUtility";
    private static final String TRANSACTION_MANAGER_CLASS_NAME = "oracle.j2ee.transaction.OC4JTransactionManager";
    private static final String TRANSACTION_CLASS_NAME = "oracle.j2ee.transaction.OC4JTransaction";
    private static final String FALLBACK_TRANSACTION_MANAGER_CLASS_NAME = "com.evermind.server.ApplicationServerTransactionManager";
    private static final String FALLBACK_TRANSACTION_CLASS_NAME = "com.evermind.server.ApplicationServerTransaction";
    private Method beginWithNameMethod;
    private Method setTransactionIsolationMethod;
    static /* synthetic */ Class class$java$lang$String;

    public void afterPropertiesSet() throws TransactionSystemException {
        super.afterPropertiesSet();
        this.loadOC4JTransactionClasses();
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(TRANSACTION_UTILITY_CLASS_NAME);
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            this.logger.debug((Object)"Retrieving JTA UserTransaction from OC4J TransactionUtility");
            Method method2 = object.getClass().getMethod("getOC4JUserTransaction", new Class[0]);
            return (UserTransaction)method2.invoke(object, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.debug((Object)("Could not find OC4J 10.1.3.2 TransactionUtility: " + classNotFoundException));
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransactionSystemException("OC4J's TransactionUtility.getOC4JUserTransaction() method failed", invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new TransactionSystemException("Could not invoke OC4J's TransactionUtility.getOC4JUserTransaction() method", exception);
        }
    }

    private void loadOC4JTransactionClasses() throws TransactionSystemException {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(TRANSACTION_MANAGER_CLASS_NAME);
            clazz2 = this.getClass().getClassLoader().loadClass(TRANSACTION_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = this.getClass().getClassLoader().loadClass(FALLBACK_TRANSACTION_MANAGER_CLASS_NAME);
                clazz2 = this.getClass().getClassLoader().loadClass(FALLBACK_TRANSACTION_CLASS_NAME);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new TransactionSystemException("Could not initialize OC4JJtaTransactionManager because OC4J API classes are not available", classNotFoundException);
            }
        }
        if (clazz.isInstance(this.getUserTransaction())) {
            this.beginWithNameMethod = ClassUtils.getMethodIfAvailable(clazz, (String)"begin", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = OC4JJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String});
            this.setTransactionIsolationMethod = ClassUtils.getMethodIfAvailable(clazz2, (String)"setTransactionIsolation", (Class[])new Class[]{Integer.TYPE});
            this.logger.info((Object)"Support for OC4J transaction names and isolation levels available");
        } else {
            this.logger.info((Object)"Support for OC4J transaction names and isolation levels not available");
        }
    }

    protected void doJtaBegin(JtaTransactionObject jtaTransactionObject, TransactionDefinition transactionDefinition) throws NotSupportedException, SystemException {
        int n = this.determineTimeout(transactionDefinition);
        this.applyTimeout(jtaTransactionObject, n);
        if (this.beginWithNameMethod != null && transactionDefinition.getName() != null) {
            try {
                this.beginWithNameMethod.invoke((Object)jtaTransactionObject.getUserTransaction(), transactionDefinition.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TransactionSystemException("OC4J's UserTransaction.begin(String) method failed", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new TransactionSystemException("Could not invoke OC4J's UserTransaction.begin(String) method", exception);
            }
        } else {
            jtaTransactionObject.getUserTransaction().begin();
        }
        if (this.setTransactionIsolationMethod != null) {
            if (transactionDefinition.getIsolationLevel() != -1) {
                try {
                    Transaction transaction = this.getTransactionManager().getTransaction();
                    Integer n2 = new Integer(transactionDefinition.getIsolationLevel());
                    this.setTransactionIsolationMethod.invoke((Object)transaction, n2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new TransactionSystemException("OC4J's Transaction.setTransactionIsolation(int) method failed", invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    throw new TransactionSystemException("Could not invoke OC4J's Transaction.setTransactionIsolation(int) method", exception);
                }
            }
        } else {
            this.applyIsolationLevel(jtaTransactionObject, transactionDefinition.getIsolationLevel());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

