/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.jta.JtaAfterCompletionSynchronization;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.util.Assert;

public class JtaTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean,
Serializable {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager"};
    private transient JndiTemplate jndiTemplate = new JndiTemplate();
    private transient UserTransaction userTransaction;
    private String userTransactionName;
    private boolean autodetectUserTransaction = true;
    private boolean cacheUserTransaction = true;
    private transient TransactionManager transactionManager;
    private String transactionManagerName;
    private boolean autodetectTransactionManager = true;
    private boolean allowCustomIsolationLevels = false;
    static /* synthetic */ Class class$javax$transaction$UserTransaction;
    static /* synthetic */ Class class$javax$transaction$TransactionManager;

    public JtaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JtaTransactionManager(UserTransaction userTransaction) {
        this();
        Assert.notNull((Object)userTransaction, (String)"UserTransaction must not be null");
        this.userTransaction = userTransaction;
    }

    public JtaTransactionManager(UserTransaction userTransaction, TransactionManager transactionManager) {
        this();
        Assert.notNull((Object)userTransaction, (String)"UserTransaction must not be null");
        Assert.notNull((Object)transactionManager, (String)"TransactionManager must not be null");
        this.userTransaction = userTransaction;
        this.transactionManager = transactionManager;
    }

    public JtaTransactionManager(TransactionManager transactionManager) {
        this();
        Assert.notNull((Object)transactionManager, (String)"TransactionManager must not be null");
        this.transactionManager = transactionManager;
        this.userTransaction = this.buildUserTransaction(transactionManager);
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        if (jndiTemplate == null) {
            throw new IllegalArgumentException("jndiTemplate must not be null");
        }
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiEnvironment(Properties properties) {
        this.jndiTemplate = new JndiTemplate(properties);
    }

    public Properties getJndiEnvironment() {
        return this.jndiTemplate.getEnvironment();
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setUserTransactionName(String string) {
        this.userTransactionName = string;
    }

    public void setAutodetectUserTransaction(boolean bl) {
        this.autodetectUserTransaction = bl;
    }

    public void setCacheUserTransaction(boolean bl) {
        this.cacheUserTransaction = bl;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManagerName(String string) {
        this.transactionManagerName = string;
    }

    public void setAutodetectTransactionManager(boolean bl) {
        this.autodetectTransactionManager = bl;
    }

    public void setAllowCustomIsolationLevels(boolean bl) {
        this.allowCustomIsolationLevels = bl;
    }

    public void afterPropertiesSet() throws TransactionSystemException {
        this.initUserTransactionAndTransactionManager();
    }

    protected void initUserTransactionAndTransactionManager() throws TransactionSystemException {
        if (this.userTransaction == null) {
            this.userTransaction = this.userTransactionName != null ? this.lookupUserTransaction(this.userTransactionName) : this.retrieveUserTransaction();
        }
        if (this.transactionManager == null) {
            this.transactionManager = this.transactionManagerName != null ? this.lookupTransactionManager(this.transactionManagerName) : this.retrieveTransactionManager();
        }
        if (this.userTransaction == null && this.autodetectUserTransaction) {
            this.userTransaction = this.findUserTransaction();
        }
        if (this.transactionManager == null && this.autodetectTransactionManager) {
            this.transactionManager = this.findTransactionManager(this.userTransaction);
        }
        if (this.userTransaction == null && this.transactionManager != null) {
            this.userTransaction = this.buildUserTransaction(this.transactionManager);
        }
        if (this.userTransaction != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA UserTransaction: " + this.userTransaction));
            }
        } else {
            throw new IllegalStateException("Either 'userTransaction' or 'userTransactionName' or 'transactionManager' or 'transactionManagerName' must be specified");
        }
        if (this.transactionManager != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA TransactionManager: " + this.transactionManager));
            }
        } else {
            this.logger.warn((Object)"No JTA TransactionManager found: transaction suspension and synchronization with existing JTA transactions not available");
        }
    }

    protected UserTransaction lookupUserTransaction(String string) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving JTA UserTransaction from JNDI location [" + string + "]"));
            }
            return (UserTransaction)this.getJndiTemplate().lookup(string, class$javax$transaction$UserTransaction == null ? (class$javax$transaction$UserTransaction = JtaTransactionManager.class$("javax.transaction.UserTransaction")) : class$javax$transaction$UserTransaction);
        }
        catch (NamingException namingException) {
            throw new TransactionSystemException("JTA UserTransaction is not available at JNDI location [" + string + "]", namingException);
        }
    }

    protected TransactionManager lookupTransactionManager(String string) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving JTA TransactionManager from JNDI location [" + string + "]"));
            }
            return (TransactionManager)this.getJndiTemplate().lookup(string, class$javax$transaction$TransactionManager == null ? (class$javax$transaction$TransactionManager = JtaTransactionManager.class$("javax.transaction.TransactionManager")) : class$javax$transaction$TransactionManager);
        }
        catch (NamingException namingException) {
            throw new TransactionSystemException("JTA TransactionManager is not available at JNDI location [" + string + "]", namingException);
        }
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        return null;
    }

    protected TransactionManager retrieveTransactionManager() throws TransactionSystemException {
        return null;
    }

    protected UserTransaction findUserTransaction() {
        String string = DEFAULT_USER_TRANSACTION_NAME;
        try {
            UserTransaction userTransaction = (UserTransaction)this.getJndiTemplate().lookup(string, class$javax$transaction$UserTransaction == null ? (class$javax$transaction$UserTransaction = JtaTransactionManager.class$("javax.transaction.UserTransaction")) : class$javax$transaction$UserTransaction);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("JTA UserTransaction found at default JNDI location [" + string + "]"));
            }
            return userTransaction;
        }
        catch (NamingException namingException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No JTA UserTransaction found at default JNDI location [" + string + "]"), (Throwable)namingException);
            }
            return null;
        }
    }

    protected TransactionManager findTransactionManager(UserTransaction userTransaction) {
        if (userTransaction instanceof TransactionManager) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("JTA UserTransaction object [" + userTransaction + "] implements TransactionManager"));
            }
            return (TransactionManager)userTransaction;
        }
        for (int i = 0; i < FALLBACK_TRANSACTION_MANAGER_NAMES.length; ++i) {
            String string = FALLBACK_TRANSACTION_MANAGER_NAMES[i];
            try {
                TransactionManager transactionManager = (TransactionManager)this.getJndiTemplate().lookup(string, class$javax$transaction$TransactionManager == null ? (class$javax$transaction$TransactionManager = JtaTransactionManager.class$("javax.transaction.TransactionManager")) : class$javax$transaction$TransactionManager);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("JTA TransactionManager found at fallback JNDI location [" + string + "]"));
                }
                return transactionManager;
            }
            catch (NamingException namingException) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("No JTA TransactionManager found at fallback JNDI location [" + string + "]"), (Throwable)namingException);
                continue;
            }
        }
        return null;
    }

    protected UserTransaction buildUserTransaction(TransactionManager transactionManager) {
        if (transactionManager instanceof UserTransaction) {
            return (UserTransaction)transactionManager;
        }
        return new UserTransactionAdapter(transactionManager);
    }

    protected Object doGetTransaction() {
        UserTransaction userTransaction = this.getUserTransaction();
        if (!this.cacheUserTransaction) {
            userTransaction = this.lookupUserTransaction(this.userTransactionName != null ? this.userTransactionName : DEFAULT_USER_TRANSACTION_NAME);
        }
        return this.doGetJtaTransaction(userTransaction);
    }

    protected JtaTransactionObject doGetJtaTransaction(UserTransaction userTransaction) {
        return new JtaTransactionObject(userTransaction);
    }

    protected boolean isExistingTransaction(Object object) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)object;
        try {
            return jtaTransactionObject.getUserTransaction().getStatus() != 6;
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on getStatus", systemException);
        }
    }

    protected boolean useSavepointForNestedTransaction() {
        return false;
    }

    protected void doBegin(Object object, TransactionDefinition transactionDefinition) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)object;
        try {
            this.doJtaBegin(jtaTransactionObject, transactionDefinition);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", notSupportedException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", unsupportedOperationException);
        }
        catch (SystemException systemException) {
            throw new CannotCreateTransactionException("JTA failure on begin", systemException);
        }
    }

    protected void doJtaBegin(JtaTransactionObject jtaTransactionObject, TransactionDefinition transactionDefinition) throws NotSupportedException, SystemException {
        this.applyIsolationLevel(jtaTransactionObject, transactionDefinition.getIsolationLevel());
        int n = this.determineTimeout(transactionDefinition);
        this.applyTimeout(jtaTransactionObject, n);
        jtaTransactionObject.getUserTransaction().begin();
    }

    protected void applyIsolationLevel(JtaTransactionObject jtaTransactionObject, int n) throws InvalidIsolationLevelException, SystemException {
        if (!this.allowCustomIsolationLevels && n != -1) {
            throw new InvalidIsolationLevelException("JtaTransactionManager does not support custom isolation levels by default - switch 'allowCustomIsolationLevels' to 'true'");
        }
    }

    protected void applyTimeout(JtaTransactionObject jtaTransactionObject, int n) throws SystemException {
        if (n > -1) {
            jtaTransactionObject.getUserTransaction().setTransactionTimeout(n);
        }
    }

    protected Object doSuspend(Object object) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)object;
        try {
            return this.doJtaSuspend(jtaTransactionObject);
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on suspend", systemException);
        }
    }

    protected Object doJtaSuspend(JtaTransactionObject jtaTransactionObject) throws SystemException {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction: specify the 'transactionManager' or 'transactionManagerName' property");
        }
        return this.getTransactionManager().suspend();
    }

    protected void doResume(Object object, Object object2) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)object;
        try {
            this.doJtaResume(jtaTransactionObject, object2);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new IllegalTransactionStateException("Tried to resume invalid JTA transaction", invalidTransactionException);
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on resume", systemException);
        }
    }

    protected void doJtaResume(JtaTransactionObject jtaTransactionObject, Object object) throws InvalidTransactionException, SystemException {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction: specify the 'transactionManager' or 'transactionManagerName' property");
        }
        this.getTransactionManager().resume((Transaction)object);
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)defaultTransactionStatus.getTransaction();
        try {
            jtaTransactionObject.getUserTransaction().commit();
        }
        catch (RollbackException rollbackException) {
            throw new UnexpectedRollbackException("JTA transaction unexpectedly rolled back (maybe due to a timeout)", rollbackException);
        }
        catch (HeuristicMixedException heuristicMixedException) {
            throw new HeuristicCompletionException(3, (Throwable)heuristicMixedException);
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            throw new HeuristicCompletionException(2, (Throwable)heuristicRollbackException);
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on commit", systemException);
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)defaultTransactionStatus.getTransaction();
        try {
            if (jtaTransactionObject.getUserTransaction().getStatus() != 6) {
                jtaTransactionObject.getUserTransaction().rollback();
            }
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on rollback", systemException);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus defaultTransactionStatus) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)defaultTransactionStatus.getTransaction();
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)"Setting JTA transaction rollback-only");
        }
        try {
            if (jtaTransactionObject.getUserTransaction().getStatus() != 6) {
                jtaTransactionObject.getUserTransaction().setRollbackOnly();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on setRollbackOnly", systemException);
        }
    }

    protected void registerAfterCompletionWithExistingTransaction(Object object, List list) {
        JtaTransactionObject jtaTransactionObject = (JtaTransactionObject)object;
        this.logger.debug((Object)"Registering after-completion synchronization with existing JTA transaction");
        try {
            this.doRegisterAfterCompletionWithJtaTransaction(jtaTransactionObject, list);
        }
        catch (RollbackException rollbackException) {
            this.logger.debug((Object)"Participating in existing JTA transaction that has been marked rollback-only: cannot register Spring after-completion callbacks with outer JTA transaction - immediately performing Spring after-completion callbacks with outcome status 'rollback'");
            this.invokeAfterCompletion(list, 1);
        }
        catch (IllegalStateException illegalStateException) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException systemException) {
            throw new TransactionSystemException("JTA failure on registerSynchronization", systemException);
        }
    }

    protected void doRegisterAfterCompletionWithJtaTransaction(JtaTransactionObject jtaTransactionObject, List list) throws RollbackException, SystemException {
        if (this.getTransactionManager() != null) {
            Transaction transaction = this.getTransactionManager().getTransaction();
            if (transaction != null) {
                transaction.registerSynchronization((Synchronization)new JtaAfterCompletionSynchronization(list));
            } else {
                this.logger.debug((Object)"Participating in existing JTA transaction, but no current JTA Transaction available: cannot register Spring after-completion callbacks with outer JTA transaction - processing Spring after-completion callbacks with outcome status 'unknown'");
                this.invokeAfterCompletion(list, 2);
            }
        } else {
            this.logger.warn((Object)"Participating in existing JTA transaction, but no JTA TransactionManager available: cannot register Spring after-completion callbacks with outer JTA transaction - processing Spring after-completion callbacks with outcome status 'unknown'");
            this.invokeAfterCompletion(list, 2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.jndiTemplate = new JndiTemplate();
        this.initUserTransactionAndTransactionManager();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

