/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;

public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor,
Serializable {
    public TransactionInterceptor() {
    }

    public TransactionInterceptor(PlatformTransactionManager platformTransactionManager, Properties properties) {
        this.setTransactionManager(platformTransactionManager);
        this.setTransactionAttributes(properties);
    }

    public TransactionInterceptor(PlatformTransactionManager platformTransactionManager, TransactionAttributeSource transactionAttributeSource) {
        this.setTransactionManager(platformTransactionManager);
        this.setTransactionAttributeSource(transactionAttributeSource);
    }

    public Object invoke(final MethodInvocation methodInvocation) throws Throwable {
        Class<?> clazz = methodInvocation.getThis() != null ? methodInvocation.getThis().getClass() : null;
        final TransactionAttribute transactionAttribute = this.getTransactionAttributeSource().getTransactionAttribute(methodInvocation.getMethod(), clazz);
        final String string = this.methodIdentification(methodInvocation.getMethod());
        if (transactionAttribute == null || !(this.getTransactionManager() instanceof CallbackPreferringPlatformTransactionManager)) {
            TransactionAspectSupport.TransactionInfo transactionInfo = this.createTransactionIfNecessary(transactionAttribute, string);
            Object object = null;
            try {
                object = methodInvocation.proceed();
            }
            catch (Throwable throwable) {
                this.completeTransactionAfterThrowing(transactionInfo, throwable);
                throw throwable;
            }
            finally {
                this.cleanupTransactionInfo(transactionInfo);
            }
            this.commitTransactionAfterReturning(transactionInfo);
            return object;
        }
        try {
            Object object = ((CallbackPreferringPlatformTransactionManager)this.getTransactionManager()).execute(transactionAttribute, new TransactionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus transactionStatus) {
                    TransactionAspectSupport.TransactionInfo transactionInfo = TransactionInterceptor.this.prepareTransactionInfo(transactionAttribute, string, transactionStatus);
                    try {
                        Object object = methodInvocation.proceed();
                        return object;
                    }
                    catch (Throwable throwable) {
                        if (transactionAttribute.rollbackOn(throwable)) {
                            throw new ThrowableHolderException(throwable);
                        }
                        ThrowableHolder throwableHolder = new ThrowableHolder(throwable);
                        return throwableHolder;
                    }
                    finally {
                        TransactionInterceptor.this.cleanupTransactionInfo(transactionInfo);
                    }
                }
            });
            if (object instanceof ThrowableHolder) {
                throw ((ThrowableHolder)object).getThrowable();
            }
            return object;
        }
        catch (ThrowableHolderException throwableHolderException) {
            throw throwableHolderException.getThrowable();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransactionManager((PlatformTransactionManager)objectInputStream.readObject());
        this.setTransactionAttributeSource((TransactionAttributeSource)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getTransactionManager());
        objectOutputStream.writeObject(this.getTransactionAttributeSource());
    }

    private static class ThrowableHolder {
        private final Throwable throwable;

        public ThrowableHolder(Throwable throwable) {
            this.throwable = throwable;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    private static class ThrowableHolderException
    extends RuntimeException {
        private final Throwable throwable;

        public ThrowableHolderException(Throwable throwable) {
            super(throwable.toString());
            this.throwable = throwable;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            return this.throwable.toString();
        }
    }
}

