/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ObjectUtils;

public class TransactionAttributeSourceAdvisor
extends AbstractPointcutAdvisor {
    private TransactionInterceptor transactionInterceptor;
    private final TransactionAttributeSourcePointcut pointcut = new TransactionAttributeSourcePointcut();
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor$TransactionAttributeSourcePointcut;

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor transactionInterceptor) {
        this.setTransactionInterceptor(transactionInterceptor);
    }

    public void setTransactionInterceptor(TransactionInterceptor transactionInterceptor) {
        this.transactionInterceptor = transactionInterceptor;
    }

    public void setClassFilter(ClassFilter classFilter) {
        this.pointcut.setClassFilter(classFilter);
    }

    public Advice getAdvice() {
        return this.transactionInterceptor;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TransactionAttributeSourcePointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        private TransactionAttributeSourcePointcut() {
        }

        private TransactionAttributeSource getTransactionAttributeSource() {
            return TransactionAttributeSourceAdvisor.this.transactionInterceptor != null ? TransactionAttributeSourceAdvisor.this.transactionInterceptor.getTransactionAttributeSource() : null;
        }

        public boolean matches(Method method, Class clazz) {
            TransactionAttributeSource transactionAttributeSource = this.getTransactionAttributeSource();
            return transactionAttributeSource != null && transactionAttributeSource.getTransactionAttribute(method, clazz) != null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TransactionAttributeSourcePointcut)) {
                return false;
            }
            TransactionAttributeSourcePointcut transactionAttributeSourcePointcut = (TransactionAttributeSourcePointcut)object;
            return ObjectUtils.nullSafeEquals((Object)this.getTransactionAttributeSource(), (Object)transactionAttributeSourcePointcut.getTransactionAttributeSource());
        }

        public int hashCode() {
            return (class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor$TransactionAttributeSourcePointcut == null ? (class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor$TransactionAttributeSourcePointcut = TransactionAttributeSourceAdvisor.class$("org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor$TransactionAttributeSourcePointcut")) : class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor$TransactionAttributeSourcePointcut).hashCode();
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.getTransactionAttributeSource();
        }
    }
}

