/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.beans.PropertyEditorSupport;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    public void setAsText(String string) throws IllegalArgumentException {
        if (StringUtils.hasLength((String)string)) {
            String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)string);
            RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = StringUtils.trimWhitespace((String)stringArray[i].trim());
                if (StringUtils.containsWhitespace((String)string2)) {
                    throw new IllegalArgumentException("Transaction attribute token contains illegal whitespace: [" + string2 + "]");
                }
                if (string2.startsWith("PROPAGATION_")) {
                    ruleBasedTransactionAttribute.setPropagationBehaviorName(string2);
                    continue;
                }
                if (string2.startsWith("ISOLATION_")) {
                    ruleBasedTransactionAttribute.setIsolationLevelName(string2);
                    continue;
                }
                if (string2.startsWith("timeout_")) {
                    String string3 = string2.substring("timeout_".length());
                    ruleBasedTransactionAttribute.setTimeout(Integer.parseInt(string3));
                    continue;
                }
                if (string2.equals("readOnly")) {
                    ruleBasedTransactionAttribute.setReadOnly(true);
                    continue;
                }
                if (string2.startsWith("+")) {
                    ruleBasedTransactionAttribute.getRollbackRules().add(new NoRollbackRuleAttribute(string2.substring(1)));
                    continue;
                }
                if (string2.startsWith("-")) {
                    ruleBasedTransactionAttribute.getRollbackRules().add(new RollbackRuleAttribute(string2.substring(1)));
                    continue;
                }
                throw new IllegalArgumentException("Invalid transaction attribute token: [" + string2 + "]");
            }
            this.setValue(ruleBasedTransactionAttribute);
        } else {
            this.setValue(null);
        }
    }
}

