/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.CompositeTransactionAttributeSource;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class TransactionAspectSupport
implements InitializingBean {
    private static final ThreadLocal transactionInfoHolder = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PlatformTransactionManager transactionManager;
    private TransactionAttributeSource transactionAttributeSource;

    protected static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        return (TransactionInfo)transactionInfoHolder.get();
    }

    public static TransactionStatus currentTransactionStatus() throws NoTransactionException {
        TransactionInfo transactionInfo = TransactionAspectSupport.currentTransactionInfo();
        if (transactionInfo == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return TransactionAspectSupport.currentTransactionInfo().transactionStatus;
    }

    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributes(Properties properties) {
        NameMatchTransactionAttributeSource nameMatchTransactionAttributeSource = new NameMatchTransactionAttributeSource();
        nameMatchTransactionAttributeSource.setProperties(properties);
        this.transactionAttributeSource = nameMatchTransactionAttributeSource;
    }

    public void setTransactionAttributeSources(TransactionAttributeSource[] transactionAttributeSourceArray) {
        this.transactionAttributeSource = new CompositeTransactionAttributeSource(transactionAttributeSourceArray);
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public TransactionAttributeSource getTransactionAttributeSource() {
        return this.transactionAttributeSource;
    }

    public void afterPropertiesSet() {
        if (this.getTransactionManager() == null) {
            throw new IllegalArgumentException("transactionManager is required");
        }
        if (this.getTransactionAttributeSource() == null) {
            throw new IllegalArgumentException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, don't use a TransactionInterceptor or TransactionProxyFactoryBean.");
        }
    }

    protected TransactionInfo createTransactionIfNecessary(Method method, Class clazz) {
        TransactionAttribute transactionAttribute = this.getTransactionAttributeSource().getTransactionAttribute(method, clazz);
        return this.createTransactionIfNecessary(transactionAttribute, this.methodIdentification(method));
    }

    protected String methodIdentification(Method method) {
        return ClassUtils.getQualifiedMethodName((Method)method);
    }

    protected TransactionInfo createTransactionIfNecessary(TransactionAttribute transactionAttribute, final String string) {
        if (transactionAttribute != null && transactionAttribute.getName() == null) {
            transactionAttribute = new DelegatingTransactionAttribute(transactionAttribute){

                public String getName() {
                    return string;
                }
            };
        }
        TransactionStatus transactionStatus = null;
        if (transactionAttribute != null) {
            PlatformTransactionManager platformTransactionManager = this.getTransactionManager();
            Assert.state((platformTransactionManager != null ? 1 : 0) != 0, (String)"Property 'transactionManager' must be set on transaction aspect");
            transactionStatus = platformTransactionManager.getTransaction(transactionAttribute);
        }
        return this.prepareTransactionInfo(transactionAttribute, string, transactionStatus);
    }

    protected TransactionInfo prepareTransactionInfo(TransactionAttribute transactionAttribute, String string, TransactionStatus transactionStatus) {
        TransactionInfo transactionInfo = new TransactionInfo(transactionAttribute, string);
        if (transactionAttribute != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting transaction for [" + transactionInfo.getJoinpointIdentification() + "]"));
            }
            transactionInfo.newTransactionStatus(transactionStatus);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Don't need to create transaction for [" + string + "]: This method isn't transactional."));
        }
        transactionInfo.bindToThread();
        return transactionInfo;
    }

    protected void commitTransactionAfterReturning(TransactionInfo transactionInfo) {
        if (transactionInfo != null && transactionInfo.hasTransaction()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Completing transaction for [" + transactionInfo.getJoinpointIdentification() + "]"));
            }
            this.transactionManager.commit(transactionInfo.getTransactionStatus());
        }
    }

    protected void completeTransactionAfterThrowing(TransactionInfo transactionInfo, Throwable throwable) {
        if (transactionInfo != null && transactionInfo.hasTransaction()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Completing transaction for [" + transactionInfo.getJoinpointIdentification() + "] after exception: " + throwable));
            }
            if (transactionInfo.transactionAttribute.rollbackOn(throwable)) {
                try {
                    this.transactionManager.rollback(transactionInfo.getTransactionStatus());
                }
                catch (RuntimeException runtimeException) {
                    this.logger.error((Object)"Application exception overridden by rollback exception", throwable);
                    throw runtimeException;
                }
                catch (Error error) {
                    this.logger.error((Object)"Application exception overridden by rollback error", throwable);
                    throw error;
                }
            }
            try {
                this.transactionManager.commit(transactionInfo.getTransactionStatus());
            }
            catch (RuntimeException runtimeException) {
                this.logger.error((Object)"Application exception overridden by commit exception", throwable);
                throw runtimeException;
            }
            catch (Error error) {
                this.logger.error((Object)"Application exception overridden by commit error", throwable);
                throw error;
            }
        }
    }

    protected void cleanupTransactionInfo(TransactionInfo transactionInfo) {
        if (transactionInfo != null) {
            transactionInfo.restoreThreadLocalStatus();
        }
    }

    protected class TransactionInfo {
        private final TransactionAttribute transactionAttribute;
        private final String joinpointIdentification;
        private TransactionStatus transactionStatus;
        private TransactionInfo oldTransactionInfo;

        public TransactionInfo(TransactionAttribute transactionAttribute, String string) {
            this.transactionAttribute = transactionAttribute;
            this.joinpointIdentification = string;
        }

        public TransactionAttribute getTransactionAttribute() {
            return this.transactionAttribute;
        }

        public String getJoinpointIdentification() {
            return this.joinpointIdentification;
        }

        public void newTransactionStatus(TransactionStatus transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        public TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }

        public boolean hasTransaction() {
            return this.transactionStatus != null;
        }

        private void bindToThread() {
            this.oldTransactionInfo = (TransactionInfo)transactionInfoHolder.get();
            transactionInfoHolder.set(this);
        }

        private void restoreThreadLocalStatus() {
            transactionInfoHolder.set(this.oldTransactionInfo);
        }
    }
}

