/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;

public class RuleBasedTransactionAttribute
extends DefaultTransactionAttribute
implements Serializable {
    public static final String PREFIX_ROLLBACK_RULE = "-";
    public static final String PREFIX_COMMIT_RULE = "+";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute == null ? (class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute = RuleBasedTransactionAttribute.class$("org.springframework.transaction.interceptor.RuleBasedTransactionAttribute")) : class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute));
    private List rollbackRules;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute;

    public RuleBasedTransactionAttribute() {
    }

    public RuleBasedTransactionAttribute(RuleBasedTransactionAttribute ruleBasedTransactionAttribute) {
        super(ruleBasedTransactionAttribute);
        this.rollbackRules = new ArrayList(ruleBasedTransactionAttribute.rollbackRules);
    }

    public RuleBasedTransactionAttribute(int n, List list) {
        super(n);
        this.rollbackRules = list;
    }

    public void setRollbackRules(List list) {
        this.rollbackRules = list;
    }

    public List getRollbackRules() {
        if (this.rollbackRules == null) {
            this.rollbackRules = new LinkedList();
        }
        return this.rollbackRules;
    }

    public boolean rollbackOn(Throwable throwable) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applying rules to determine whether transaction should rollback on " + throwable));
        }
        RollbackRuleAttribute rollbackRuleAttribute = null;
        int n = Integer.MAX_VALUE;
        if (this.rollbackRules != null) {
            Iterator iterator = this.rollbackRules.iterator();
            while (iterator.hasNext()) {
                RollbackRuleAttribute rollbackRuleAttribute2 = (RollbackRuleAttribute)iterator.next();
                int n2 = rollbackRuleAttribute2.getDepth(throwable);
                if (n2 < 0 || n2 >= n) continue;
                n = n2;
                rollbackRuleAttribute = rollbackRuleAttribute2;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Winning rollback rule is: " + rollbackRuleAttribute));
        }
        if (rollbackRuleAttribute == null) {
            logger.debug((Object)"No relevant rollback rule found: applying superclass default");
            return super.rollbackOn(throwable);
        }
        return !(rollbackRuleAttribute instanceof NoRollbackRuleAttribute);
    }

    public String toString() {
        StringBuffer stringBuffer = this.getDefinitionDescription();
        if (this.rollbackRules != null) {
            Iterator iterator = this.rollbackRules.iterator();
            while (iterator.hasNext()) {
                RollbackRuleAttribute rollbackRuleAttribute = (RollbackRuleAttribute)iterator.next();
                String string = rollbackRuleAttribute instanceof NoRollbackRuleAttribute ? PREFIX_COMMIT_RULE : PREFIX_ROLLBACK_RULE;
                stringBuffer.append(',').append(string).append(rollbackRuleAttribute.getExceptionName());
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

