/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public class NameMatchTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = NameMatchTransactionAttributeSource.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource));
    private Map nameMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    public void setNameMap(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            TransactionAttribute transactionAttribute = null;
            if (entry.getValue() instanceof TransactionAttribute) {
                transactionAttribute = (TransactionAttribute)entry.getValue();
            } else {
                TransactionAttributeEditor transactionAttributeEditor = new TransactionAttributeEditor();
                transactionAttributeEditor.setAsText(entry.getValue().toString());
                transactionAttribute = (TransactionAttribute)transactionAttributeEditor.getValue();
            }
            this.addTransactionalMethod(string, transactionAttribute);
        }
    }

    public void setProperties(Properties properties) {
        TransactionAttributeEditor transactionAttributeEditor = new TransactionAttributeEditor();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            transactionAttributeEditor.setAsText(string2);
            TransactionAttribute transactionAttribute = (TransactionAttribute)transactionAttributeEditor.getValue();
            this.addTransactionalMethod(string, transactionAttribute);
        }
    }

    public void addTransactionalMethod(String string, TransactionAttribute transactionAttribute) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding transactional method [" + string + "] with attribute [" + transactionAttribute + "]"));
        }
        this.nameMap.put(string, transactionAttribute);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class clazz) {
        String string = method.getName();
        TransactionAttribute transactionAttribute = (TransactionAttribute)this.nameMap.get(string);
        if (transactionAttribute == null) {
            String string2 = null;
            Iterator iterator = this.nameMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!this.isMatch(string, string3) || string2 != null && string2.length() > string3.length()) continue;
                transactionAttribute = (TransactionAttribute)this.nameMap.get(string3);
                string2 = string3;
            }
        }
        return transactionAttribute;
    }

    protected boolean isMatch(String string, String string2) {
        return PatternMatchUtils.simpleMatch((String)string2, (String)string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NameMatchTransactionAttributeSource)) {
            return false;
        }
        NameMatchTransactionAttributeSource nameMatchTransactionAttributeSource = (NameMatchTransactionAttributeSource)object;
        return ObjectUtils.nullSafeEquals((Object)this.nameMap, (Object)nameMatchTransactionAttributeSource.nameMap);
    }

    public int hashCode() {
        return (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = NameMatchTransactionAttributeSource.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource).hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.nameMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

