/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public class MethodMapTransactionAttributeSource
implements TransactionAttributeSource,
BeanClassLoaderAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map methodMap;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean eagerlyInitialized = false;
    private boolean initialized = false;
    private final Map transactionAttributeMap = new HashMap();
    private final Map methodNameMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionAttribute;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$MethodMapTransactionAttributeSource;

    public void setMethodMap(Map map) {
        this.methodMap = map;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() {
        this.initMethodMap(this.methodMap);
        this.eagerlyInitialized = true;
        this.initialized = true;
    }

    protected void initMethodMap(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (!(k instanceof String)) {
                    throw new IllegalArgumentException("Invalid method map key [" + k + "]: only Strings allowed");
                }
                Object v = entry.getValue();
                TransactionAttribute transactionAttribute = null;
                if (v instanceof TransactionAttribute) {
                    transactionAttribute = (TransactionAttribute)v;
                } else if (v instanceof String) {
                    TransactionAttributeEditor transactionAttributeEditor = new TransactionAttributeEditor();
                    transactionAttributeEditor.setAsText((String)v);
                    transactionAttribute = (TransactionAttribute)transactionAttributeEditor.getValue();
                } else {
                    throw new IllegalArgumentException("Value [" + v + "] is neither of type [" + (class$org$springframework$transaction$interceptor$TransactionAttribute == null ? (class$org$springframework$transaction$interceptor$TransactionAttribute = MethodMapTransactionAttributeSource.class$("org.springframework.transaction.interceptor.TransactionAttribute")) : class$org$springframework$transaction$interceptor$TransactionAttribute).getName() + "] nor a String");
                }
                this.addTransactionalMethod((String)k, transactionAttribute);
            }
        }
    }

    public void addTransactionalMethod(String string, TransactionAttribute transactionAttribute) {
        Assert.notNull((Object)string, (String)"Name must not be null");
        int n = string.lastIndexOf(".");
        if (n == -1) {
            throw new IllegalArgumentException("'" + string + "' is not a valid method name: format is FQN.methodName");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Class clazz = ClassUtils.resolveClassName((String)string2, (ClassLoader)this.beanClassLoader);
        this.addTransactionalMethod(clazz, string3, transactionAttribute);
    }

    public void addTransactionalMethod(Class clazz, String string, TransactionAttribute transactionAttribute) {
        Assert.notNull((Object)clazz, (String)"Class must not be null");
        Assert.notNull((Object)string, (String)"Mapped name must not be null");
        String string2 = clazz.getName() + '.' + string;
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!this.isMatch(methodArray[i].getName(), string)) continue;
            arrayList.add(methodArray[i]);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find method '" + string + "' on class [" + clazz.getName() + "]");
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            String string3 = (String)this.methodNameMap.get(method);
            if (string3 == null || !string3.equals(string2) && string3.length() <= string2.length()) {
                if (this.logger.isDebugEnabled() && string3 != null) {
                    this.logger.debug((Object)("Replacing attribute for transactional method [" + method + "]: current name '" + string2 + "' is more specific than '" + string3 + "'"));
                }
                this.methodNameMap.put(method, string2);
                this.addTransactionalMethod(method, transactionAttribute);
                continue;
            }
            if (!this.logger.isDebugEnabled() || string3 == null) continue;
            this.logger.debug((Object)("Keeping attribute for transactional method [" + method + "]: current name '" + string2 + "' is not more specific than '" + string3 + "'"));
        }
    }

    public void addTransactionalMethod(Method method, TransactionAttribute transactionAttribute) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)transactionAttribute, (String)"TransactionAttribute must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding transactional method [" + method + "] with attribute [" + transactionAttribute + "]"));
        }
        this.transactionAttributeMap.put(method, transactionAttribute);
    }

    protected boolean isMatch(String string, String string2) {
        return PatternMatchUtils.simpleMatch((String)string2, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionAttribute getTransactionAttribute(Method method, Class clazz) {
        if (this.eagerlyInitialized) {
            return (TransactionAttribute)this.transactionAttributeMap.get(method);
        }
        Map map = this.transactionAttributeMap;
        synchronized (map) {
            if (!this.initialized) {
                this.initMethodMap(this.methodMap);
                this.initialized = true;
            }
            return (TransactionAttribute)this.transactionAttributeMap.get(method);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodMapTransactionAttributeSource)) {
            return false;
        }
        MethodMapTransactionAttributeSource methodMapTransactionAttributeSource = (MethodMapTransactionAttributeSource)object;
        return ObjectUtils.nullSafeEquals((Object)this.methodMap, (Object)methodMapTransactionAttributeSource.methodMap);
    }

    public int hashCode() {
        return (class$org$springframework$transaction$interceptor$MethodMapTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$MethodMapTransactionAttributeSource = MethodMapTransactionAttributeSource.class$("org.springframework.transaction.interceptor.MethodMapTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$MethodMapTransactionAttributeSource).hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.methodMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

