/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;

public class CompositeTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    private final TransactionAttributeSource[] transactionAttributeSources;

    public CompositeTransactionAttributeSource(TransactionAttributeSource[] transactionAttributeSourceArray) {
        Assert.notNull((Object)transactionAttributeSourceArray, (String)"TransactionAttributeSource array must not be null");
        this.transactionAttributeSources = transactionAttributeSourceArray;
    }

    public final TransactionAttributeSource[] getTransactionAttributeSources() {
        return this.transactionAttributeSources;
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class clazz) {
        for (int i = 0; i < this.transactionAttributeSources.length; ++i) {
            TransactionAttributeSource transactionAttributeSource = this.transactionAttributeSources[i];
            TransactionAttribute transactionAttribute = transactionAttributeSource.getTransactionAttribute(method, clazz);
            if (transactionAttribute == null) continue;
            return transactionAttribute;
        }
        return null;
    }
}

