/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ObjectUtils;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource {
    private static final Object NULL_TRANSACTION_ATTRIBUTE = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    final Map attributeCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionAttribute getTransactionAttribute(Method method, Class clazz) {
        Object object = this.getCacheKey(method, clazz);
        Map map = this.attributeCache;
        synchronized (map) {
            Object v = this.attributeCache.get(object);
            if (v != null) {
                if (v == NULL_TRANSACTION_ATTRIBUTE) {
                    return null;
                }
                return (TransactionAttribute)v;
            }
            TransactionAttribute transactionAttribute = this.computeTransactionAttribute(method, clazz);
            if (transactionAttribute == null) {
                this.attributeCache.put(object, NULL_TRANSACTION_ATTRIBUTE);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Adding transactional method [" + method.getName() + "] with attribute [" + transactionAttribute + "]"));
                }
                this.attributeCache.put(object, transactionAttribute);
            }
            return transactionAttribute;
        }
    }

    protected Object getCacheKey(Method method, Class clazz) {
        return new DefaultCacheKey(method, clazz);
    }

    private TransactionAttribute computeTransactionAttribute(Method method, Class clazz) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method method2 = AopUtils.getMostSpecificMethod((Method)method, (Class)clazz);
        TransactionAttribute transactionAttribute = this.findTransactionAttribute(this.findAllAttributes(method2));
        if (transactionAttribute != null) {
            return transactionAttribute;
        }
        transactionAttribute = this.findTransactionAttribute(this.findAllAttributes(method2.getDeclaringClass()));
        if (transactionAttribute != null) {
            return transactionAttribute;
        }
        if (method2 != method) {
            transactionAttribute = this.findTransactionAttribute(this.findAllAttributes(method));
            if (transactionAttribute != null) {
                return transactionAttribute;
            }
            return this.findTransactionAttribute(this.findAllAttributes(method.getDeclaringClass()));
        }
        return null;
    }

    protected abstract Collection findAllAttributes(Method var1);

    protected abstract Collection findAllAttributes(Class var1);

    protected TransactionAttribute findTransactionAttribute(Collection collection) {
        Object object;
        if (collection == null) {
            return null;
        }
        TransactionAttribute transactionAttribute = null;
        Object object2 = collection.iterator();
        while (object2.hasNext() && transactionAttribute == null) {
            object = object2.next();
            if (!(object instanceof TransactionAttribute)) continue;
            transactionAttribute = (TransactionAttribute)object;
        }
        if (transactionAttribute instanceof RuleBasedTransactionAttribute) {
            object2 = (RuleBasedTransactionAttribute)transactionAttribute;
            object = new LinkedList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof RollbackRuleAttribute)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found rollback rule: " + e));
                }
                object.add(e);
            }
            ((RuleBasedTransactionAttribute)object2).setRollbackRules((List)object);
        }
        return transactionAttribute;
    }

    protected boolean allowPublicMethodsOnly() {
        return false;
    }

    private static class DefaultCacheKey {
        private final Method method;
        private final Class targetClass;

        public DefaultCacheKey(Method method, Class clazz) {
            this.method = method;
            this.targetClass = clazz;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey defaultCacheKey = (DefaultCacheKey)object;
            return this.method.equals(defaultCacheKey.method) && ObjectUtils.nullSafeEquals((Object)this.targetClass, (Object)defaultCacheKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() * 29 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        }
    }
}

