/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.config.TxNamespaceUtils;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class TxAdviceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ATTRIBUTES = "attributes";
    private static final String TIMEOUT = "timeout";
    private static final String READ_ONLY = "read-only";
    private static final String NAME_MAP = "nameMap";
    private static final String PROPAGATION = "propagation";
    private static final String ISOLATION = "isolation";
    private static final String ROLLBACK_FOR = "rollback-for";
    private static final String NO_ROLLBACK_FOR = "no-rollback-for";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    TxAdviceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
        beanDefinitionBuilder.addPropertyReference(TxNamespaceUtils.TRANSACTION_MANAGER_PROPERTY, element.getAttribute("transaction-manager"));
        List list = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTES);
        if (list.size() > 1) {
            parserContext.getReaderContext().error("Element <attributes> is allowed at most once inside element <advice>", (Object)element);
        } else if (list.size() == 1) {
            Element element2 = (Element)list.get(0);
            RootBeanDefinition rootBeanDefinition = this.parseAttributeSource(element2, parserContext);
            beanDefinitionBuilder.addPropertyValue("transactionAttributeSource", (Object)rootBeanDefinition);
        } else {
            Class clazz = TxNamespaceUtils.getAnnotationTransactionAttributeSourceClass();
            beanDefinitionBuilder.addPropertyValue("transactionAttributeSource", (Object)new RootBeanDefinition(clazz));
        }
    }

    private RootBeanDefinition parseAttributeSource(Element element, ParserContext parserContext) {
        List list = DomUtils.getChildElementsByTagName((Element)element, (String)"method");
        ManagedMap managedMap = new ManagedMap(list.size());
        managedMap.setSource(parserContext.extractSource((Object)element));
        for (int i = 0; i < list.size(); ++i) {
            String string;
            Element element2 = (Element)list.get(i);
            String string2 = element2.getAttribute("name");
            TypedStringValue typedStringValue = new TypedStringValue(string2);
            typedStringValue.setSource(parserContext.extractSource((Object)element2));
            RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
            String string3 = element2.getAttribute(PROPAGATION);
            String string4 = element2.getAttribute(ISOLATION);
            String string5 = element2.getAttribute(TIMEOUT);
            String string6 = element2.getAttribute(READ_ONLY);
            if (StringUtils.hasText((String)string3)) {
                ruleBasedTransactionAttribute.setPropagationBehaviorName("PROPAGATION_" + string3);
            }
            if (StringUtils.hasText((String)string4)) {
                ruleBasedTransactionAttribute.setIsolationLevelName("ISOLATION_" + string4);
            }
            if (StringUtils.hasText((String)string5)) {
                try {
                    ruleBasedTransactionAttribute.setTimeout(Integer.parseInt(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    parserContext.getReaderContext().error("Timeout must be an integer value: [" + string5 + "]", (Object)element2);
                }
            }
            if (StringUtils.hasText((String)string6)) {
                ruleBasedTransactionAttribute.setReadOnly(Boolean.valueOf(element2.getAttribute(READ_ONLY)));
            }
            LinkedList linkedList = new LinkedList();
            if (element2.hasAttribute(ROLLBACK_FOR)) {
                string = element2.getAttribute(ROLLBACK_FOR);
                this.addRollbackRuleAttributesTo(linkedList, string);
            }
            if (element2.hasAttribute(NO_ROLLBACK_FOR)) {
                string = element2.getAttribute(NO_ROLLBACK_FOR);
                this.addNoRollbackRuleAttributesTo(linkedList, string);
            }
            ruleBasedTransactionAttribute.setRollbackRules(linkedList);
            managedMap.put((Object)typedStringValue, (Object)ruleBasedTransactionAttribute);
        }
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource);
        rootBeanDefinition.setSource(parserContext.extractSource((Object)element));
        rootBeanDefinition.getPropertyValues().addPropertyValue(NAME_MAP, (Object)managedMap);
        return rootBeanDefinition;
    }

    private void addRollbackRuleAttributesTo(List list, String string) {
        String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(new RollbackRuleAttribute(StringUtils.trimWhitespace((String)stringArray[i])));
        }
    }

    private void addNoRollbackRuleAttributesTo(List list, String string) {
        String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(new NoRollbackRuleAttribute(StringUtils.trimWhitespace((String)stringArray[i])));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

