/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.AbstractFallbackTransactionAttributeSource;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class AnnotationTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements Serializable {
    private final boolean publicMethodsOnly;

    public AnnotationTransactionAttributeSource() {
        this.publicMethodsOnly = true;
    }

    public AnnotationTransactionAttributeSource(boolean bl) {
        this.publicMethodsOnly = bl;
    }

    protected Collection findAllAttributes(Method method) {
        return Arrays.asList(AnnotationUtils.getAnnotations((Method)method));
    }

    protected Collection findAllAttributes(Class clazz) {
        return Arrays.asList(clazz.getAnnotations());
    }

    protected TransactionAttribute findTransactionAttribute(Collection collection) {
        if (collection == null) {
            return null;
        }
        for (Object e : collection) {
            if (!(e instanceof Transactional)) continue;
            Transactional transactional = (Transactional)e;
            RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
            ruleBasedTransactionAttribute.setPropagationBehavior(transactional.propagation().value());
            ruleBasedTransactionAttribute.setIsolationLevel(transactional.isolation().value());
            ruleBasedTransactionAttribute.setTimeout(transactional.timeout());
            ruleBasedTransactionAttribute.setReadOnly(transactional.readOnly());
            ArrayList<RollbackRuleAttribute> arrayList = new ArrayList<RollbackRuleAttribute>();
            Class<? extends Throwable>[] classArray = transactional.rollbackFor();
            for (int i = 0; i < classArray.length; ++i) {
                RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(classArray[i]);
                arrayList.add(rollbackRuleAttribute);
            }
            String[] stringArray = transactional.rollbackForClassName();
            for (int i = 0; i < stringArray.length; ++i) {
                RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(stringArray[i]);
                arrayList.add(rollbackRuleAttribute);
            }
            Class<? extends Throwable>[] classArray2 = transactional.noRollbackFor();
            for (int i = 0; i < classArray2.length; ++i) {
                NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(classArray2[i]);
                arrayList.add(noRollbackRuleAttribute);
            }
            String[] stringArray2 = transactional.noRollbackForClassName();
            for (int i = 0; i < stringArray2.length; ++i) {
                NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(stringArray2[i]);
                arrayList.add(noRollbackRuleAttribute);
            }
            ruleBasedTransactionAttribute.getRollbackRules().addAll(arrayList);
            return ruleBasedTransactionAttribute;
        }
        return null;
    }

    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof AnnotationTransactionAttributeSource;
    }

    public int hashCode() {
        return AnnotationTransactionAttributeSource.class.hashCode();
    }
}

