/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.Iterator;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;

public class PersistenceExceptionTranslationInterceptor
implements MethodInterceptor,
BeanFactoryAware,
InitializingBean {
    private PersistenceExceptionTranslator persistenceExceptionTranslator;
    static /* synthetic */ Class class$org$springframework$dao$support$PersistenceExceptionTranslator;

    public PersistenceExceptionTranslationInterceptor() {
    }

    public PersistenceExceptionTranslationInterceptor(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.setPersistenceExceptionTranslator(persistenceExceptionTranslator);
    }

    public PersistenceExceptionTranslationInterceptor(ListableBeanFactory listableBeanFactory) {
        this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators(listableBeanFactory);
    }

    public void setPersistenceExceptionTranslator(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        Assert.notNull((Object)persistenceExceptionTranslator, (String)"PersistenceExceptionTranslator must not be null");
        this.persistenceExceptionTranslator = persistenceExceptionTranslator;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.persistenceExceptionTranslator == null) {
            if (!(beanFactory instanceof ListableBeanFactory)) {
                throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
            }
            this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators((ListableBeanFactory)beanFactory);
        }
    }

    public void afterPropertiesSet() {
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("Property 'persistenceExceptionTranslator' is required");
        }
    }

    protected PersistenceExceptionTranslator detectPersistenceExceptionTranslators(ListableBeanFactory listableBeanFactory) {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)listableBeanFactory, (Class)(class$org$springframework$dao$support$PersistenceExceptionTranslator == null ? (class$org$springframework$dao$support$PersistenceExceptionTranslator = PersistenceExceptionTranslationInterceptor.class$("org.springframework.dao.support.PersistenceExceptionTranslator")) : class$org$springframework$dao$support$PersistenceExceptionTranslator), (boolean)false, (boolean)false);
        if (map.isEmpty()) {
            throw new IllegalStateException("No persistence exception translators found in bean factory. Cannot perform exception translation.");
        }
        ChainedPersistenceExceptionTranslator chainedPersistenceExceptionTranslator = new ChainedPersistenceExceptionTranslator();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            chainedPersistenceExceptionTranslator.addDelegate((PersistenceExceptionTranslator)iterator.next());
        }
        return chainedPersistenceExceptionTranslator;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        try {
            return methodInvocation.proceed();
        }
        catch (RuntimeException runtimeException) {
            Class<?>[] classArray = methodInvocation.getMethod().getExceptionTypes();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isInstance(runtimeException)) continue;
                throw runtimeException;
            }
            throw DataAccessUtils.translateIfNecessary(runtimeException, this.persistenceExceptionTranslator);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

