/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.Collection;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

public abstract class DataAccessUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public static Object singleResult(Collection collection) throws IncorrectResultSizeDataAccessException {
        int n;
        int n2 = n = collection != null ? collection.size() : 0;
        if (n == 0) {
            return null;
        }
        if (collection.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, n);
        }
        return collection.iterator().next();
    }

    public static Object requiredSingleResult(Collection collection) throws IncorrectResultSizeDataAccessException {
        int n;
        int n2 = n = collection != null ? collection.size() : 0;
        if (n == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (collection.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, n);
        }
        return collection.iterator().next();
    }

    public static Object uniqueResult(Collection collection) throws IncorrectResultSizeDataAccessException {
        int n;
        int n2 = n = collection != null ? collection.size() : 0;
        if (n == 0) {
            return null;
        }
        if (!CollectionUtils.hasUniqueObject((Collection)collection)) {
            throw new IncorrectResultSizeDataAccessException(1, n);
        }
        return collection.iterator().next();
    }

    public static Object requiredUniqueResult(Collection collection) throws IncorrectResultSizeDataAccessException {
        int n;
        int n2 = n = collection != null ? collection.size() : 0;
        if (n == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (!CollectionUtils.hasUniqueObject((Collection)collection)) {
            throw new IncorrectResultSizeDataAccessException(1, n);
        }
        return collection.iterator().next();
    }

    public static Object objectResult(Collection collection, Class clazz) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        Object object = DataAccessUtils.requiredUniqueResult(collection);
        if (clazz != null && !clazz.isInstance(object)) {
            if ((class$java$lang$String == null ? (class$java$lang$String = DataAccessUtils.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
                object = object.toString();
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) && (class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number).isInstance(object)) {
                try {
                    object = NumberUtils.convertNumberToTargetClass((Number)((Number)object), (Class)clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TypeMismatchDataAccessException(illegalArgumentException.getMessage());
                }
            } else {
                throw new TypeMismatchDataAccessException("Result object is of type [" + object.getClass().getName() + "] and could not be converted to required type [" + clazz.getName() + "]");
            }
        }
        return object;
    }

    public static int intResult(Collection collection) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return ((Number)DataAccessUtils.objectResult(collection, class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number)).intValue();
    }

    public static long longResult(Collection collection) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return ((Number)DataAccessUtils.objectResult(collection, class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number)).longValue();
    }

    public static RuntimeException translateIfNecessary(RuntimeException runtimeException, PersistenceExceptionTranslator persistenceExceptionTranslator) {
        Assert.notNull((Object)persistenceExceptionTranslator, (String)"PersistenceExceptionTranslator must not be null");
        DataAccessException dataAccessException = persistenceExceptionTranslator.translateExceptionIfPossible(runtimeException);
        return dataAccessException != null ? dataAccessException : runtimeException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

