/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;

public class ChainedPersistenceExceptionTranslator
implements PersistenceExceptionTranslator {
    private final List delegates = new ArrayList(4);

    public final void addDelegate(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        Assert.notNull((Object)persistenceExceptionTranslator, (String)"PersistenceExceptionTranslator must not be null");
        this.delegates.add(persistenceExceptionTranslator);
    }

    public final PersistenceExceptionTranslator[] getDelegates() {
        return this.delegates.toArray(new PersistenceExceptionTranslator[this.delegates.size()]);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException runtimeException) {
        DataAccessException dataAccessException = null;
        Iterator iterator = this.delegates.iterator();
        while (dataAccessException == null && iterator.hasNext()) {
            PersistenceExceptionTranslator persistenceExceptionTranslator = (PersistenceExceptionTranslator)iterator.next();
            dataAccessException = persistenceExceptionTranslator.translateExceptionIfPossible(runtimeException);
        }
        return dataAccessException;
    }
}

