/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.taglibs.standard.tag.common.xml.UnresolvableException;

public class JSTLXPathVariableResolver
implements XPathVariableResolver {
    private PageContext pageContext;
    private static final String PAGE_NS_URL = "http://java.sun.com/jstl/xpath/page";
    private static final String REQUEST_NS_URL = "http://java.sun.com/jstl/xpath/request";
    private static final String SESSION_NS_URL = "http://java.sun.com/jstl/xpath/session";
    private static final String APP_NS_URL = "http://java.sun.com/jstl/xpath/app";
    private static final String PARAM_NS_URL = "http://java.sun.com/jstl/xpath/param";
    private static final String INITPARAM_NS_URL = "http://java.sun.com/jstl/xpath/initParam";
    private static final String COOKIE_NS_URL = "http://java.sun.com/jstl/xpath/cookie";
    private static final String HEADER_NS_URL = "http://java.sun.com/jstl/xpath/header";

    public JSTLXPathVariableResolver(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Object resolveVariable(QName qName) throws NullPointerException {
        Object object = null;
        if (qName == null) {
            throw new NullPointerException("Cannot resolve null variable");
        }
        String string = qName.getNamespaceURI();
        String string2 = qName.getPrefix();
        String string3 = qName.getLocalPart();
        try {
            object = this.getVariableValue(string, string2, string3);
        }
        catch (UnresolvableException unresolvableException) {
            System.out.println("JSTLXpathVariableResolver.resolveVariable threw UnresolvableException: " + unresolvableException);
        }
        return object;
    }

    protected Object getVariableValue(String string, String string2, String string3) throws UnresolvableException {
        if (string == null || string.equals("")) {
            return this.notNull(this.pageContext.findAttribute(string3), string, string3);
        }
        if (string.equals(PAGE_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(string3, 1), string, string3);
        }
        if (string.equals(REQUEST_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(string3, 2), string, string3);
        }
        if (string.equals(SESSION_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(string3, 3), string, string3);
        }
        if (string.equals(APP_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(string3, 4), string, string3);
        }
        if (string.equals(PARAM_NS_URL)) {
            return this.notNull(this.pageContext.getRequest().getParameter(string3), string, string3);
        }
        if (string.equals(INITPARAM_NS_URL)) {
            return this.notNull(this.pageContext.getServletContext().getInitParameter(string3), string, string3);
        }
        if (string.equals(HEADER_NS_URL)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            return this.notNull(httpServletRequest.getHeader(string3), string, string3);
        }
        if (string.equals(COOKIE_NS_URL)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            Cookie[] cookieArray = httpServletRequest.getCookies();
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!cookieArray[i].getName().equals(string3)) continue;
                return cookieArray[i].getValue();
            }
            throw new UnresolvableException("$" + string + ":" + string3);
        }
        throw new UnresolvableException("$" + string + ":" + string3);
    }

    private Object notNull(Object object, String string, String string2) throws UnresolvableException {
        if (object == null) {
            throw new UnresolvableException("$" + (string == null ? "" : string + ":") + string2);
        }
        return object;
    }

    private static void p(String string) {
        System.out.println("[JSTLXPathVariableResolver] " + string);
    }
}

