/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.apache.taglibs.standard.resources.Resources;

public final class IteratedExpression {
    private static final long serialVersionUID = 1L;
    protected final ValueExpression orig;
    protected final String delims;
    private Object base;
    private int index;
    private Iterator iter;

    public IteratedExpression(ValueExpression valueExpression, String string) {
        this.orig = valueExpression;
        this.delims = string;
    }

    public Object getItem(ELContext eLContext, int n) {
        if (this.base == null) {
            this.base = this.orig.getValue(eLContext);
            if (this.base == null) {
                return null;
            }
            this.iter = this.toIterator(this.base);
            this.index = 0;
        }
        if (this.index > n) {
            this.iter = this.toIterator(this.base);
            this.index = 0;
        }
        while (this.iter.hasNext()) {
            Object e = this.iter.next();
            if (this.index++ != n) continue;
            return e;
        }
        return null;
    }

    public ValueExpression getValueExpression() {
        return this.orig;
    }

    private Iterator toIterator(Object object) {
        Iterator iterator;
        if (object instanceof String) {
            iterator = this.toIterator(new StringTokenizer((String)object, this.delims));
        } else if (object instanceof Iterator) {
            iterator = (Iterator)object;
        } else if (object instanceof Collection) {
            iterator = this.toIterator(((Collection)object).iterator());
        } else if (object instanceof Enumeration) {
            iterator = this.toIterator((Enumeration)object);
        } else if (object instanceof Map) {
            iterator = ((Map)object).entrySet().iterator();
        } else {
            throw new ELException(Resources.getMessage("FOREACH_BAD_ITEMS"));
        }
        return iterator;
    }

    private Iterator toIterator(final Enumeration enumeration) {
        return new Iterator(){

            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return enumeration.nextElement();
            }

            public void remove() {
            }
        };
    }
}

