/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.attributes.validation.AttributeValidator;
import org.apache.commons.attributes.validation.ValidationException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class AttributeValidatorTask
extends Task {
    private File jarFile;
    private List classes = new ArrayList();
    private List validators = new ArrayList();
    private Path classPath;
    private File baseName;
    private boolean inMaven = false;
    private static final String SUFFIX = "$__attributeRepository.class";

    public void setJarfile(File file) {
        this.jarFile = file;
    }

    public void setBaseName(File file) {
        this.inMaven = true;
        this.baseName = file;
    }

    public Path createClasspath() {
        this.classPath = new Path(((ProjectComponent)this).project);
        return this.classPath;
    }

    public Validator createValidator() {
        Validator validator = new Validator();
        this.validators.add(validator);
        return validator;
    }

    protected void findJarFile() throws BuildException {
        File[] fileArray = this.baseName.getParentFile().listFiles();
        if (fileArray == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
        long l = 0L;
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getName();
            if (string.startsWith(this.baseName.getName()) && string.endsWith(".jar") && fileArray[n].lastModified() > l) {
                this.jarFile = fileArray[n];
                l = fileArray[n].lastModified();
            }
            ++n;
        }
        if (this.jarFile == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.inMaven) {
            this.findJarFile();
        }
        if (!this.jarFile.exists()) {
            this.log("Can't find " + this.jarFile.getPath());
            return;
        }
        try {
            Object object;
            Object object2;
            Cloneable cloneable;
            AntClassLoader antClassLoader;
            this.log("Validating attributes in " + this.jarFile.getPath());
            JarFile jarFile = new JarFile(this.jarFile);
            try {
                antClassLoader = jarFile.entries();
                while (antClassLoader.hasMoreElements()) {
                    cloneable = antClassLoader.nextElement();
                    if (((ZipEntry)cloneable).isDirectory() || !((String)(object2 = ((ZipEntry)cloneable).getName())).endsWith(SUFFIX)) continue;
                    object2 = ((String)object2).replace('/', '.').replace('\\', '.').substring(0, ((String)object2).length() - SUFFIX.length());
                    this.classes.add(object2);
                }
                object = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                jarFile.close();
                throw throwable;
            }
            jarFile.close();
            antClassLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), ((ProjectComponent)this).project, this.classPath, true);
            try {
                Object object3;
                antClassLoader.addPathElement(this.jarFile.getPath());
                cloneable = new HashSet();
                object2 = this.classes.iterator();
                while (object2.hasNext()) {
                    object3 = (String)object2.next();
                    object = antClassLoader.loadClass((String)object3);
                    ((HashSet)cloneable).add(object);
                }
                object3 = this.validators.iterator();
                while (object3.hasNext()) {
                    object = (Validator)object3.next();
                    Class<?> clazz = antClassLoader.loadClass(((Validator)object).getClassName());
                    AttributeValidator attributeValidator = (AttributeValidator)clazz.newInstance();
                    try {
                        attributeValidator.validate((Set)((Object)cloneable));
                    }
                    catch (ValidationException validationException) {
                        throw new BuildException(validationException.getInvalidClass() + " failed to validate: " + validationException.getMessage());
                    }
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                antClassLoader.cleanup();
                throw throwable;
            }
            antClassLoader.cleanup();
            {
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException(exception.toString());
        }
    }

    static {
        SUFFIX = SUFFIX;
    }

    public static class Validator {
        private String className;

        public void setClass(String string) {
            this.className = string;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

